/*
 * Decompiled with CFR 0.152.
 */
package dev.paseto.jpaseto.impl.crypto;

import dev.paseto.jpaseto.lang.Assert;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class Hmacs {
    private Hmacs() {
    }

    public static byte[] hmacSha384(byte[] key, byte[] input) {
        try {
            Mac mac = Mac.getInstance("HmacSHA384");
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, "HmacSHA384");
            mac.init(secretKeySpec);
            return mac.doFinal(input);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new SecurityException("Could not calculate 'HmacSHA384'", e);
        }
    }

    static byte[] createNonce(byte[] key, byte[] input) {
        Assert.isTrue((key != null && key.length == 32 ? 1 : 0) != 0, (String)"Key length must be 32 bytes");
        return Arrays.copyOf(Hmacs.hmacSha384(key, input), 32);
    }
}

