/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.MutableStructure;
import dev.openfeature.sdk.Structure;
import dev.openfeature.sdk.Value;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;

public class MutableContext
implements EvaluationContext {
    private String targetingKey;
    private final MutableStructure structure;

    public MutableContext() {
        this.structure = new MutableStructure();
        this.targetingKey = "";
    }

    public MutableContext(String targetingKey) {
        this();
        this.targetingKey = targetingKey;
    }

    public MutableContext(Map<String, Value> attributes) {
        this.structure = new MutableStructure(attributes);
        this.targetingKey = "";
    }

    public MutableContext(String targetingKey, Map<String, Value> attributes) {
        this(attributes);
        this.targetingKey = targetingKey;
    }

    public MutableContext add(String key, Boolean value) {
        this.structure.add(key, value);
        return this;
    }

    public MutableContext add(String key, String value) {
        this.structure.add(key, value);
        return this;
    }

    public MutableContext add(String key, Integer value) {
        this.structure.add(key, value);
        return this;
    }

    public MutableContext add(String key, Double value) {
        this.structure.add(key, value);
        return this;
    }

    public MutableContext add(String key, Instant value) {
        this.structure.add(key, value);
        return this;
    }

    public MutableContext add(String key, Structure value) {
        this.structure.add(key, value);
        return this;
    }

    public MutableContext add(String key, List<Value> value) {
        this.structure.add(key, value);
        return this;
    }

    @Override
    public EvaluationContext merge(EvaluationContext overridingContext) {
        if (overridingContext == null) {
            return new MutableContext(this.targetingKey, this.asMap());
        }
        Map<String, Value> merged = this.merge(map -> new MutableStructure((Map<String, Value>)map), this.asMap(), overridingContext.asMap());
        String newTargetingKey = "";
        if (this.getTargetingKey() != null && !this.getTargetingKey().trim().equals("")) {
            newTargetingKey = this.getTargetingKey();
        }
        if (overridingContext.getTargetingKey() != null && !overridingContext.getTargetingKey().trim().equals("")) {
            newTargetingKey = overridingContext.getTargetingKey();
        }
        MutableContext ec = null;
        ec = newTargetingKey != null && !newTargetingKey.trim().equals("") ? new MutableContext(newTargetingKey, merged) : new MutableContext(merged);
        return ec;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "MutableContext(targetingKey=" + this.getTargetingKey() + ", structure=" + this.structure + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MutableContext)) {
            return false;
        }
        MutableContext other = (MutableContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$targetingKey = this.getTargetingKey();
        String other$targetingKey = other.getTargetingKey();
        if (this$targetingKey == null ? other$targetingKey != null : !this$targetingKey.equals(other$targetingKey)) {
            return false;
        }
        MutableStructure this$structure = this.structure;
        MutableStructure other$structure = other.structure;
        return !(this$structure == null ? other$structure != null : !((Object)this$structure).equals(other$structure));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MutableContext;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $targetingKey = this.getTargetingKey();
        result = result * 59 + ($targetingKey == null ? 43 : $targetingKey.hashCode());
        MutableStructure $structure = this.structure;
        result = result * 59 + ($structure == null ? 43 : ((Object)$structure).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setTargetingKey(String targetingKey) {
        this.targetingKey = targetingKey;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getTargetingKey() {
        return this.targetingKey;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Set<String> keySet() {
        return this.structure.keySet();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Value getValue(String key) {
        return this.structure.getValue(key);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, Value> asMap() {
        return this.structure.asMap();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, Object> asObjectMap() {
        return this.structure.asObjectMap();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Object convertValue(Value value) {
        return this.structure.convertValue(value);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public <T extends Structure> Map<String, Value> merge(Function<Map<String, Value>, Structure> newStructure, Map<String, Value> base, Map<String, Value> overriding) {
        return this.structure.merge(newStructure, base, overriding);
    }

    private static class HideDelegateAddMethods {
        private HideDelegateAddMethods() {
        }

        public MutableStructure add(String ignoredKey, Boolean ignoredValue) {
            return null;
        }

        public MutableStructure add(String ignoredKey, Double ignoredValue) {
            return null;
        }

        public MutableStructure add(String ignoredKey, String ignoredValue) {
            return null;
        }

        public MutableStructure add(String ignoredKey, Value ignoredValue) {
            return null;
        }

        public MutableStructure add(String ignoredKey, Integer ignoredValue) {
            return null;
        }

        public MutableStructure add(String ignoredKey, List<Value> ignoredValue) {
            return null;
        }

        public MutableStructure add(String ignoredKey, MutableStructure ignoredValue) {
            return null;
        }

        public MutableStructure add(String ignoredKey, Instant ignoredValue) {
            return null;
        }
    }
}

