/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk.multiprovider;

import dev.openfeature.sdk.ErrorCode;
import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.FeatureProvider;
import dev.openfeature.sdk.ProviderEvaluation;
import dev.openfeature.sdk.exceptions.FlagNotFoundError;
import dev.openfeature.sdk.multiprovider.Strategy;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirstMatchStrategy
implements Strategy {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FirstMatchStrategy.class);

    @Override
    public <T> ProviderEvaluation<T> evaluate(Map<String, FeatureProvider> providers, String key, T defaultValue, EvaluationContext ctx, Function<FeatureProvider, ProviderEvaluation<T>> providerFunction) {
        for (FeatureProvider provider : providers.values()) {
            try {
                ProviderEvaluation<T> res = providerFunction.apply(provider);
                ErrorCode errorCode = res.getErrorCode();
                if (errorCode == null) {
                    return res;
                }
                if (ErrorCode.FLAG_NOT_FOUND.equals((Object)errorCode)) continue;
                return res;
            }
            catch (FlagNotFoundError flagNotFoundError) {
            }
        }
        return ProviderEvaluation.builder().errorMessage("Flag not found in any provider").errorCode(ErrorCode.FLAG_NOT_FOUND).build();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public FirstMatchStrategy() {
    }
}

