/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import dev.openfeature.sdk.ClientMetadata;
import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.FlagValueType;
import dev.openfeature.sdk.HookData;
import dev.openfeature.sdk.Metadata;
import dev.openfeature.sdk.SharedHookContext;
import dev.openfeature.sdk.internal.ExcludeFromGeneratedCoverageReport;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;

public final class HookContext<T> {
    private final SharedHookContext<T> sharedContext;
    private EvaluationContext ctx;
    private final HookData hookData;

    HookContext(@NonNull SharedHookContext<T> sharedContext, EvaluationContext evaluationContext, HookData hookData) {
        if (sharedContext == null) {
            throw new NullPointerException("sharedContext is marked non-null but is null");
        }
        this.sharedContext = sharedContext;
        this.ctx = evaluationContext;
        this.hookData = hookData;
    }

    @Deprecated
    HookContext(@NonNull String flagKey, @NonNull FlagValueType type, @NonNull T defaultValue, @NonNull EvaluationContext ctx, ClientMetadata clientMetadata, Metadata providerMetadata, HookData hookData) {
        this(new SharedHookContext<T>(flagKey, type, clientMetadata, providerMetadata, defaultValue), ctx, hookData);
        if (flagKey == null) {
            throw new NullPointerException("flagKey is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
    }

    @Deprecated
    public static <T> HookContext<T> from(String key, FlagValueType type, ClientMetadata clientMetadata, Metadata providerMetadata, EvaluationContext ctx, T defaultValue) {
        return HookContext.builder().flagKey(key).type(type).clientMetadata(clientMetadata).providerMetadata(providerMetadata).ctx(ctx).defaultValue(defaultValue).hookData(null).build();
    }

    @Deprecated
    public static <T> HookContextBuilder<T> builder() {
        return new HookContextBuilder();
    }

    @NonNull
    public String getFlagKey() {
        return this.sharedContext.getFlagKey();
    }

    @NonNull
    public FlagValueType getType() {
        return this.sharedContext.getType();
    }

    @NonNull
    public T getDefaultValue() {
        return this.sharedContext.getDefaultValue();
    }

    @NonNull
    public EvaluationContext getCtx() {
        return this.ctx;
    }

    public ClientMetadata getClientMetadata() {
        return this.sharedContext.getClientMetadata();
    }

    public Metadata getProviderMetadata() {
        return this.sharedContext.getProviderMetadata();
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Intentional exposure of hookData")
    public HookData getHookData() {
        return this.hookData;
    }

    void setCtx(@NonNull EvaluationContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        this.ctx = ctx;
    }

    @ExcludeFromGeneratedCoverageReport
    @Deprecated
    public HookContext<T> withFlagKey(@NonNull String flagKey) {
        if (flagKey == null) {
            throw new NullPointerException("flagKey is marked non-null but is null");
        }
        return Objects.equals(this.getFlagKey(), flagKey) ? this : new HookContext<T>(flagKey, this.getType(), this.getDefaultValue(), this.getCtx(), this.getClientMetadata(), this.getProviderMetadata(), this.hookData);
    }

    @ExcludeFromGeneratedCoverageReport
    @Deprecated
    public HookContext<T> withType(@NonNull FlagValueType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.getType() == type ? this : new HookContext<T>(this.getFlagKey(), type, this.getDefaultValue(), this.getCtx(), this.getClientMetadata(), this.getProviderMetadata(), this.hookData);
    }

    @ExcludeFromGeneratedCoverageReport
    @Deprecated
    public HookContext<T> withDefaultValue(@NonNull T defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return this.getDefaultValue() == defaultValue ? this : new HookContext<T>(this.getFlagKey(), this.getType(), defaultValue, this.getCtx(), this.getClientMetadata(), this.getProviderMetadata(), this.hookData);
    }

    @ExcludeFromGeneratedCoverageReport
    @Deprecated
    public HookContext<T> withCtx(@NonNull EvaluationContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        return this.ctx == ctx ? this : new HookContext<T>(this.getFlagKey(), this.getType(), this.getDefaultValue(), ctx, this.getClientMetadata(), this.getProviderMetadata(), this.hookData);
    }

    @ExcludeFromGeneratedCoverageReport
    @Deprecated
    public HookContext<T> withClientMetadata(ClientMetadata clientMetadata) {
        return this.getClientMetadata() == clientMetadata ? this : new HookContext<T>(this.getFlagKey(), this.getType(), this.getDefaultValue(), this.getCtx(), clientMetadata, this.getProviderMetadata(), this.hookData);
    }

    @ExcludeFromGeneratedCoverageReport
    @Deprecated
    public HookContext<T> withProviderMetadata(Metadata providerMetadata) {
        return this.getProviderMetadata() == providerMetadata ? this : new HookContext<T>(this.getFlagKey(), this.getType(), this.getDefaultValue(), this.getCtx(), this.getClientMetadata(), providerMetadata, this.hookData);
    }

    @ExcludeFromGeneratedCoverageReport
    @Deprecated
    public HookContext<T> withHookData(HookData hookData) {
        return this.hookData == hookData ? this : new HookContext<T>(this.getFlagKey(), this.getType(), this.getDefaultValue(), this.getCtx(), this.getClientMetadata(), this.getProviderMetadata(), hookData);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HookContext)) {
            return false;
        }
        HookContext other = (HookContext)o;
        SharedHookContext<T> this$sharedContext = this.sharedContext;
        SharedHookContext<T> other$sharedContext = other.sharedContext;
        if (this$sharedContext == null ? other$sharedContext != null : !((Object)this$sharedContext).equals(other$sharedContext)) {
            return false;
        }
        EvaluationContext this$ctx = this.getCtx();
        EvaluationContext other$ctx = other.getCtx();
        if (this$ctx == null ? other$ctx != null : !this$ctx.equals(other$ctx)) {
            return false;
        }
        HookData this$hookData = this.getHookData();
        HookData other$hookData = other.getHookData();
        return !(this$hookData == null ? other$hookData != null : !this$hookData.equals(other$hookData));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SharedHookContext<T> $sharedContext = this.sharedContext;
        result = result * 59 + ($sharedContext == null ? 43 : ((Object)$sharedContext).hashCode());
        EvaluationContext $ctx = this.getCtx();
        result = result * 59 + ($ctx == null ? 43 : $ctx.hashCode());
        HookData $hookData = this.getHookData();
        result = result * 59 + ($hookData == null ? 43 : $hookData.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "HookContext(sharedContext=" + String.valueOf(this.sharedContext) + ", ctx=" + String.valueOf(this.getCtx()) + ", hookData=" + String.valueOf(this.getHookData()) + ")";
    }

    @Deprecated
    public static class HookContextBuilder<T> {
        private String flagKey;
        private FlagValueType type;
        private T defaultValue;
        private EvaluationContext ctx;
        private ClientMetadata clientMetadata;
        private Metadata providerMetadata;
        private HookData hookData;

        HookContextBuilder() {
        }

        @ExcludeFromGeneratedCoverageReport
        public HookContextBuilder<T> flagKey(@NonNull String flagKey) {
            if (flagKey == null) {
                throw new NullPointerException("flagKey is marked non-null but is null");
            }
            this.flagKey = flagKey;
            return this;
        }

        @ExcludeFromGeneratedCoverageReport
        public HookContextBuilder<T> type(@NonNull FlagValueType type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        @ExcludeFromGeneratedCoverageReport
        public HookContextBuilder<T> defaultValue(@NonNull T defaultValue) {
            if (defaultValue == null) {
                throw new NullPointerException("defaultValue is marked non-null but is null");
            }
            this.defaultValue = defaultValue;
            return this;
        }

        @ExcludeFromGeneratedCoverageReport
        public HookContextBuilder<T> ctx(@NonNull EvaluationContext ctx) {
            if (ctx == null) {
                throw new NullPointerException("ctx is marked non-null but is null");
            }
            this.ctx = ctx;
            return this;
        }

        @ExcludeFromGeneratedCoverageReport
        public HookContextBuilder<T> clientMetadata(ClientMetadata clientMetadata) {
            this.clientMetadata = clientMetadata;
            return this;
        }

        @ExcludeFromGeneratedCoverageReport
        public HookContextBuilder<T> providerMetadata(Metadata providerMetadata) {
            this.providerMetadata = providerMetadata;
            return this;
        }

        @ExcludeFromGeneratedCoverageReport
        @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Intentional exposure of hookData")
        public HookContextBuilder<T> hookData(HookData hookData) {
            this.hookData = hookData;
            return this;
        }

        @ExcludeFromGeneratedCoverageReport
        public HookContext<T> build() {
            return new HookContext<T>(this.flagKey, this.type, this.defaultValue, this.ctx, this.clientMetadata, this.providerMetadata, this.hookData);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "HookContext.HookContextBuilder(flagKey=" + this.flagKey + ", type=" + String.valueOf((Object)this.type) + ", defaultValue=" + String.valueOf(this.defaultValue) + ", ctx=" + String.valueOf(this.ctx) + ", clientMetadata=" + String.valueOf(this.clientMetadata) + ", providerMetadata=" + String.valueOf(this.providerMetadata) + ", hookData=" + String.valueOf(this.hookData) + ")";
        }
    }
}

