/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import dev.openfeature.sdk.Structure;
import dev.openfeature.sdk.Value;
import java.util.Map;
import java.util.function.Function;

public interface EvaluationContext
extends Structure {
    public static final String TARGETING_KEY = "targetingKey";

    public String getTargetingKey();

    public EvaluationContext merge(EvaluationContext var1);

    default public boolean isEqualTo(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof EvaluationContext)) {
            return false;
        }
        EvaluationContext otherContext = (EvaluationContext)other;
        return this.asUnmodifiableMap().equals(otherContext.asUnmodifiableMap());
    }

    public static void mergeMaps(Function<Map<String, Value>, Structure> newStructure, Map<String, Value> base, Map<String, Value> overriding) {
        if (base == null) {
            return;
        }
        if (overriding == null || overriding.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Value> overridingEntry : overriding.entrySet()) {
            String key = overridingEntry.getKey();
            if (overridingEntry.getValue().isStructure() && base.containsKey(key) && base.get(key).isStructure()) {
                Structure mergedValue = base.get(key).asStructure();
                Structure overridingValue = overridingEntry.getValue().asStructure();
                Map<String, Value> newMap = mergedValue.asMap();
                EvaluationContext.mergeMaps(newStructure, newMap, overridingValue.asUnmodifiableMap());
                base.put(key, new Value(newStructure.apply(newMap)));
                continue;
            }
            base.put(key, overridingEntry.getValue());
        }
    }
}

