package dev.openfeature.sdk;

import lombok.Setter;
import lombok.ToString;

@ToString
class Pair<K, V> {
    private final K key;

    @Setter
    private V value;

    private Pair(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public K getKey() {
        return key;
    }

    public V getValue() {
        return value;
    }

    public static <K, V> Pair<K, V> of(K key, V value) {
        return new Pair<>(key, value);
    }
}
