/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LayeredEvaluationContext
implements EvaluationContext {
    private final EvaluationContext apiContext;
    private final EvaluationContext transactionContext;
    private final EvaluationContext clientContext;
    private final EvaluationContext invocationContext;
    private ArrayList<EvaluationContext> hookContexts;
    private String targetingKey;
    private Set<String> keySet = null;

    public LayeredEvaluationContext(EvaluationContext apiContext, EvaluationContext transactionContext, EvaluationContext clientContext, EvaluationContext invocationContext) {
        this.apiContext = apiContext;
        this.transactionContext = transactionContext;
        this.clientContext = clientContext;
        this.invocationContext = invocationContext;
        this.targetingKey = invocationContext != null && invocationContext.getTargetingKey() != null ? invocationContext.getTargetingKey() : (clientContext != null && clientContext.getTargetingKey() != null ? clientContext.getTargetingKey() : (transactionContext != null && transactionContext.getTargetingKey() != null ? transactionContext.getTargetingKey() : (apiContext != null && apiContext.getTargetingKey() != null ? apiContext.getTargetingKey() : null)));
    }

    @Override
    public String getTargetingKey() {
        return this.targetingKey;
    }

    @Override
    public EvaluationContext merge(EvaluationContext overridingContext) {
        LayeredEvaluationContext merged = new LayeredEvaluationContext(this.apiContext, this.transactionContext, this.clientContext, this.invocationContext);
        if (this.hookContexts == null) {
            merged.hookContexts = new ArrayList(1);
        } else {
            merged.hookContexts = new ArrayList(this.hookContexts.size() + 1);
            merged.hookContexts.addAll(this.hookContexts);
        }
        merged.hookContexts.add(overridingContext);
        String otherTargetingKey = overridingContext.getTargetingKey();
        if (otherTargetingKey != null) {
            merged.targetingKey = otherTargetingKey;
        }
        return merged;
    }

    @Override
    public boolean isEmpty() {
        return !(this.invocationContext != null && !this.invocationContext.isEmpty() || this.clientContext != null && !this.clientContext.isEmpty() || this.transactionContext != null && !this.transactionContext.isEmpty() || this.apiContext != null && !this.apiContext.isEmpty() || !this.areHookContextsEmpty());
    }

    private boolean areHookContextsEmpty() {
        if (this.hookContexts == null || this.hookContexts.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.hookContexts.size(); ++i) {
            EvaluationContext current = this.hookContexts.get(i);
            if (current.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.ensureKeySet());
    }

    private Set<String> ensureKeySet() {
        if (this.keySet != null) {
            return this.keySet;
        }
        HashSet<String> keys = new HashSet<String>();
        if (this.hookContexts != null) {
            for (int i = 0; i < this.hookContexts.size(); ++i) {
                EvaluationContext current = this.hookContexts.get(i);
                keys.addAll(current.keySet());
            }
        }
        if (this.invocationContext != null) {
            keys.addAll(this.invocationContext.keySet());
        }
        if (this.clientContext != null) {
            keys.addAll(this.clientContext.keySet());
        }
        if (this.transactionContext != null) {
            keys.addAll(this.transactionContext.keySet());
        }
        if (this.apiContext != null) {
            keys.addAll(this.apiContext.keySet());
        }
        this.keySet = keys;
        return keys;
    }

    private Value getFromContext(EvaluationContext context, String key) {
        if (context != null) {
            return context.getValue(key);
        }
        return null;
    }

    private Value getFromContext(ArrayList<EvaluationContext> context, String key) {
        if (context == null) {
            return null;
        }
        for (int i = context.size() - 1; i >= 0; --i) {
            EvaluationContext current = context.get(i);
            Value value = this.getFromContext(current, key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public Value getValue(String key) {
        Value hookValue = this.getFromContext(this.hookContexts, key);
        if (hookValue != null) {
            return hookValue;
        }
        Value invocationValue = this.getFromContext(this.invocationContext, key);
        if (invocationValue != null) {
            return invocationValue;
        }
        Value clientValue = this.getFromContext(this.clientContext, key);
        if (clientValue != null) {
            return clientValue;
        }
        Value transactionValue = this.getFromContext(this.transactionContext, key);
        if (transactionValue != null) {
            return transactionValue;
        }
        return this.getFromContext(this.apiContext, key);
    }

    @Override
    public Map<String, Value> asMap() {
        if (this.keySet != null && this.keySet.isEmpty()) {
            return new HashMap<String, Value>(0);
        }
        HashMap<String, Value> map = this.keySet != null ? new HashMap(this.keySet.size()) : new HashMap<String, Value>();
        if (this.apiContext != null) {
            map.putAll(this.apiContext.asMap());
        }
        if (this.transactionContext != null) {
            map.putAll(this.transactionContext.asMap());
        }
        if (this.clientContext != null) {
            map.putAll(this.clientContext.asMap());
        }
        if (this.invocationContext != null) {
            map.putAll(this.invocationContext.asMap());
        }
        if (this.hookContexts != null) {
            for (int i = 0; i < this.hookContexts.size(); ++i) {
                EvaluationContext hookContext = this.hookContexts.get(i);
                map.putAll(hookContext.asMap());
            }
        }
        return map;
    }

    @Override
    public Map<String, Value> asUnmodifiableMap() {
        if (this.keySet != null && this.keySet.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.asMap());
    }

    @Override
    public Map<String, Object> asObjectMap() {
        if (this.keySet != null && this.keySet.isEmpty()) {
            return new HashMap<String, Object>(0);
        }
        HashMap<String, Object> map = this.keySet != null ? new HashMap(this.keySet.size()) : new HashMap<String, Object>();
        if (this.apiContext != null) {
            map.putAll(this.apiContext.asObjectMap());
        }
        if (this.transactionContext != null) {
            map.putAll(this.transactionContext.asObjectMap());
        }
        if (this.clientContext != null) {
            map.putAll(this.clientContext.asObjectMap());
        }
        if (this.invocationContext != null) {
            map.putAll(this.invocationContext.asObjectMap());
        }
        if (this.hookContexts != null) {
            for (int i = 0; i < this.hookContexts.size(); ++i) {
                EvaluationContext hookContext = this.hookContexts.get(i);
                map.putAll(hookContext.asObjectMap());
            }
        }
        return map;
    }

    void putHookContext(EvaluationContext context) {
        if (context == null || context.isEmpty()) {
            return;
        }
        String targetingKey = context.getTargetingKey();
        if (targetingKey != null) {
            this.targetingKey = targetingKey;
        }
        if (this.hookContexts == null) {
            this.hookContexts = new ArrayList();
        }
        this.hookContexts.add(context);
        this.keySet = null;
    }
}

