/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.FlagEvaluationDetails;
import dev.openfeature.sdk.FlagValueType;
import dev.openfeature.sdk.Hook;
import dev.openfeature.sdk.HookContext;
import dev.openfeature.sdk.HookContextWithData;
import dev.openfeature.sdk.HookData;
import dev.openfeature.sdk.Pair;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HookSupport {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HookSupport.class);

    public EvaluationContext beforeHooks(FlagValueType flagValueType, HookContext hookCtx, List<Pair<Hook, HookData>> hookDataPairs, Map<String, Object> hints) {
        return this.callBeforeHooks(flagValueType, hookCtx, hookDataPairs, hints);
    }

    public void afterHooks(FlagValueType flagValueType, HookContext hookContext, FlagEvaluationDetails details, List<Pair<Hook, HookData>> hookDataPairs, Map<String, Object> hints) {
        this.executeHooksUnchecked(flagValueType, hookDataPairs, hookContext, (hook, ctx) -> hook.after(ctx, details, hints));
    }

    public void afterAllHooks(FlagValueType flagValueType, HookContext hookCtx, FlagEvaluationDetails details, List<Pair<Hook, HookData>> hookDataPairs, Map<String, Object> hints) {
        this.executeHooks(flagValueType, hookDataPairs, hookCtx, "finally", (hook, ctx) -> hook.finallyAfter(ctx, details, hints));
    }

    public void errorHooks(FlagValueType flagValueType, HookContext hookCtx, Exception e, List<Pair<Hook, HookData>> hookDataPairs, Map<String, Object> hints) {
        this.executeHooks(flagValueType, hookDataPairs, hookCtx, "error", (hook, ctx) -> hook.error(ctx, e, hints));
    }

    public List<Pair<Hook, HookData>> getHookDataPairs(List<Hook> hooks, FlagValueType flagValueType) {
        ArrayList<Pair<Hook, HookData>> pairs = new ArrayList<Pair<Hook, HookData>>();
        for (Hook hook : hooks) {
            if (!hook.supportsFlagValueType(flagValueType)) continue;
            pairs.add(Pair.of(hook, HookData.create()));
        }
        return pairs;
    }

    private <T> void executeHooks(FlagValueType flagValueType, List<Pair<Hook, HookData>> hookDataPairs, HookContext hookContext, String hookMethod, BiConsumer<Hook<T>, HookContext> hookCode) {
        if (hookDataPairs != null) {
            for (Pair<Hook, HookData> hookDataPair : hookDataPairs) {
                Hook hook = hookDataPair.getLeft();
                HookData hookData = hookDataPair.getRight();
                this.executeChecked(hook, hookData, hookContext, hookCode, hookMethod);
            }
        }
    }

    private <T> void executeChecked(Hook<T> hook, HookData hookData, HookContext hookContext, BiConsumer<Hook<T>, HookContext> hookCode, String hookMethod) {
        try {
            HookContextWithData hookCtxWithData = HookContextWithData.of(hookContext, hookData);
            hookCode.accept(hook, hookCtxWithData);
        }
        catch (Exception exception) {
            log.error("Unhandled exception when running {} hook {} (only 'after' hooks should throw)", new Object[]{hookMethod, hook.getClass(), exception});
        }
    }

    private <T> void executeHooksUnchecked(FlagValueType flagValueType, List<Pair<Hook, HookData>> hookDataPairs, HookContext hookContext, BiConsumer<Hook<T>, HookContext> hookCode) {
        if (hookDataPairs != null) {
            for (Pair<Hook, HookData> hookDataPair : hookDataPairs) {
                Hook hook = hookDataPair.getLeft();
                HookData hookData = hookDataPair.getRight();
                HookContextWithData hookCtxWithData = HookContextWithData.of(hookContext, hookData);
                hookCode.accept(hook, hookCtxWithData);
            }
        }
    }

    private EvaluationContext callBeforeHooks(FlagValueType flagValueType, HookContext hookCtx, List<Pair<Hook, HookData>> hookDataPairs, Map<String, Object> hints) {
        ArrayList<Pair<Hook, HookData>> reversedHooks = new ArrayList<Pair<Hook, HookData>>(hookDataPairs);
        Collections.reverse(reversedHooks);
        EvaluationContext context = hookCtx.getCtx();
        for (Pair pair : reversedHooks) {
            HookData hookData;
            HookContextWithData contextWithHookData;
            Hook hook = (Hook)pair.getLeft();
            Optional optional = Optional.ofNullable(hook.before(contextWithHookData = HookContextWithData.of(hookCtx, hookData = (HookData)pair.getRight()), hints)).orElse(Optional.empty());
            if (!optional.isPresent()) continue;
            context = context.merge((EvaluationContext)optional.get());
        }
        return context;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public HookSupport() {
    }
}

