/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import dev.openfeature.sdk.EventProviderListener;
import dev.openfeature.sdk.FeatureProvider;
import dev.openfeature.sdk.ProviderEvent;
import dev.openfeature.sdk.ProviderEventDetails;
import dev.openfeature.sdk.internal.TriConsumer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EventProvider
implements FeatureProvider {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventProvider.class);
    private EventProviderListener eventProviderListener;
    private final ExecutorService emitterExecutor = Executors.newCachedThreadPool();
    private TriConsumer<EventProvider, ProviderEvent, ProviderEventDetails> onEmit = null;

    void setEventProviderListener(EventProviderListener eventProviderListener) {
        this.eventProviderListener = eventProviderListener;
    }

    void attach(TriConsumer<EventProvider, ProviderEvent, ProviderEventDetails> onEmit) {
        if (this.onEmit != null && this.onEmit != onEmit) {
            throw new IllegalStateException("Provider " + this.getMetadata().getName() + " is already attached.");
        }
        this.onEmit = onEmit;
    }

    void detach() {
        this.onEmit = null;
    }

    @Override
    public void shutdown() {
        this.emitterExecutor.shutdown();
        try {
            if (!this.emitterExecutor.awaitTermination(3L, TimeUnit.SECONDS)) {
                log.warn("Emitter executor did not terminate before the timeout period had elapsed");
                this.emitterExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.emitterExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void emit(ProviderEvent event, ProviderEventDetails details) {
        TriConsumer<EventProvider, ProviderEvent, ProviderEventDetails> localOnEmit;
        if (this.eventProviderListener != null) {
            this.eventProviderListener.onEmit(event, details);
        }
        if ((localOnEmit = this.onEmit) != null) {
            this.emitterExecutor.submit(() -> localOnEmit.accept(this, event, details));
        }
    }

    public void emitProviderReady(ProviderEventDetails details) {
        this.emit(ProviderEvent.PROVIDER_READY, details);
    }

    public void emitProviderConfigurationChanged(ProviderEventDetails details) {
        this.emit(ProviderEvent.PROVIDER_CONFIGURATION_CHANGED, details);
    }

    public void emitProviderStale(ProviderEventDetails details) {
        this.emit(ProviderEvent.PROVIDER_STALE, details);
    }

    public void emitProviderError(ProviderEventDetails details) {
        this.emit(ProviderEvent.PROVIDER_ERROR, details);
    }
}

