/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.jni.internal.plugins;

import dev.nokee.language.nativebase.internal.HeaderExportingSourceSetInternal;
import dev.nokee.language.nativebase.internal.ObjectSourceSetInternal;
import dev.nokee.language.nativebase.tasks.internal.NativeSourceCompileTask;
import dev.nokee.platform.base.internal.GroupId;
import dev.nokee.platform.base.internal.NamingScheme;
import dev.nokee.platform.base.internal.NamingSchemeFactory;
import dev.nokee.platform.jni.JniLibraryExtension;
import dev.nokee.platform.jni.internal.AbstractJarBinary;
import dev.nokee.platform.jni.internal.DefaultJvmJarBinary;
import dev.nokee.platform.jni.internal.JniLibraryDependenciesInternal;
import dev.nokee.platform.jni.internal.JniLibraryExtensionInternal;
import dev.nokee.platform.jni.internal.JniLibraryInternal;
import dev.nokee.platform.jni.internal.plugins.JniLibraryRules;
import dev.nokee.platform.nativebase.TargetMachine;
import dev.nokee.platform.nativebase.TargetMachineFactory;
import dev.nokee.platform.nativebase.internal.DefaultMachineArchitecture;
import dev.nokee.platform.nativebase.internal.DefaultOperatingSystemFamily;
import dev.nokee.platform.nativebase.internal.DefaultTargetMachine;
import dev.nokee.platform.nativebase.internal.DefaultTargetMachineFactory;
import dev.nokee.platform.nativebase.internal.ToolChainSelectorInternal;
import dev.nokee.platform.nativebase.internal.plugins.FakeMavenRepositoryPlugin;
import dev.nokee.platform.nativebase.internal.plugins.NativePlatformCapabilitiesMarkerPlugin;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.Named;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.Test;
import org.gradle.jvm.tasks.Jar;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.nativeplatform.toolchain.internal.plugins.StandardToolChainsPlugin;
import org.gradle.util.GradleVersion;

public abstract class JniLibraryPlugin
implements Plugin<Project> {
    private final ToolChainSelectorInternal toolChainSelector = (ToolChainSelectorInternal)this.getObjects().newInstance(ToolChainSelectorInternal.class, new Object[0]);

    public void apply(Project project) {
        TaskContainer tasks = project.getTasks();
        project.getPluginManager().apply("base");
        project.getPluginManager().apply("lifecycle-base");
        project.getPluginManager().apply(StandardToolChainsPlugin.class);
        DefaultTargetMachineFactory targetMachineFactory = JniLibraryPlugin.registerTargetMachineFactoryAsExtension(project.getExtensions());
        JniLibraryExtensionInternal extension = this.registerExtension(project, targetMachineFactory);
        project.getPluginManager().withPlugin("java", appliedPlugin -> this.configureJavaJniRuntime(project, extension));
        project.getPluginManager().withPlugin("java", appliedPlugin -> this.registerJniHeaderSourceSet(project, extension));
        project.getPluginManager().withPlugin("java-library", appliedPlugin -> {
            throw new GradleException("Use java plugin instead");
        });
        project.getPlugins().withType(NativePlatformCapabilitiesMarkerPlugin.class, appliedPlugin -> {
            project.getPluginManager().apply(JniLibraryRules.class);
            project.getPluginManager().apply(FakeMavenRepositoryPlugin.class);
        });
        extension.getVariantCollection().configureEach(library -> library.getJar().getJarTask().configure(task -> task.from((Object)library.getNativeRuntimeFiles(), spec -> spec.into(library.getResourcePath()))));
        extension.getVariantCollection().configureEach(library -> {
            if (((Set)extension.getTargetMachines().get()).size() > 1 || !project.getPluginManager().hasPlugin("java")) {
                project.getConfigurations().getByName("runtimeElements").getOutgoing().artifact(library.getJar().getArchiveFile());
            }
        });
        NamingSchemeFactory namingSchemeFactory = new NamingSchemeFactory(project.getName());
        NamingScheme mainComponentNames = namingSchemeFactory.forMainComponent();
        project.afterEvaluate(proj -> {
            extension.getTargetMachines().disallowChanges();
            extension.getTargetMachines().finalizeValue();
            Set targetMachines = (Set)extension.getTargetMachines().get();
            JniLibraryPlugin.assertNonEmpty((Collection)extension.getTargetMachines().get(), "target machine", "library");
            this.assertTargetMachinesAreKnown(targetMachines);
            Optional<DefaultJvmJarBinary> jvmJarBinary = this.findJvmBinary((Project)proj);
            targetMachines.stream().filter(arg_0 -> ((ToolChainSelectorInternal)this.toolChainSelector).canBuild(arg_0)).forEach(targetMachine -> {
                NamingScheme names = mainComponentNames;
                names = names.withVariantDimension((Named)((DefaultOperatingSystemFamily)targetMachine.getOperatingSystemFamily()), JniLibraryPlugin.targetMachinesToOperatingSystems(targetMachines));
                names = names.withVariantDimension((Named)((DefaultMachineArchitecture)targetMachine.getArchitecture()), JniLibraryPlugin.targetMachinesToArchitectures(targetMachines));
                if (proj.getPluginManager().hasPlugin("dev.nokee.cpp-language")) {
                    extension.getSources().add(this.getObjects().newInstance(ObjectSourceSetInternal.class, new Object[]{tasks.register(names.getTaskName("compile", "cpp"), NativeSourceCompileTask.class), ObjectSourceSetInternal.LanguageType.CPP}));
                }
                if (proj.getPluginManager().hasPlugin("dev.nokee.c-language")) {
                    extension.getSources().add(this.getObjects().newInstance(ObjectSourceSetInternal.class, new Object[]{tasks.register(names.getTaskName("compile", "c"), NativeSourceCompileTask.class), ObjectSourceSetInternal.LanguageType.C}));
                }
                if (proj.getPluginManager().hasPlugin("dev.nokee.objective-cpp-language")) {
                    extension.getSources().add(this.getObjects().newInstance(ObjectSourceSetInternal.class, new Object[]{tasks.register(names.getTaskName("compile", "objectiveCpp"), NativeSourceCompileTask.class), ObjectSourceSetInternal.LanguageType.OBJECTIVE_CPP}));
                }
                if (proj.getPluginManager().hasPlugin("dev.nokee.objective-c-language")) {
                    extension.getSources().add(this.getObjects().newInstance(ObjectSourceSetInternal.class, new Object[]{tasks.register(names.getTaskName("compile", "objectiveC"), NativeSourceCompileTask.class), ObjectSourceSetInternal.LanguageType.OBJECTIVE_C}));
                }
                JniLibraryInternal library = extension.newVariant(names, (TargetMachine)targetMachine);
                library.registerSharedLibraryBinary();
                if (jvmJarBinary.isPresent() && targetMachines.size() == 1) {
                    library.addJniJarBinary((AbstractJarBinary)((Object)((Object)((Object)jvmJarBinary.get()))));
                } else {
                    library.registerJniJarBinary();
                    jvmJarBinary.ifPresent(library::addJvmJarBinary);
                }
                if (DefaultTargetMachine.isTargetingHost().test(targetMachine)) {
                    project.getTasks().named("assemble", it -> it.dependsOn(new Object[]{library.getJar().getJarTask()}));
                }
                extension.getVariantCollection().add((Object)library);
            });
        });
        tasks.named("assemble", task -> task.dependsOn(new Object[]{() -> {
            boolean targetsCurrentMachine = ((Set)extension.getTargetMachines().get()).stream().anyMatch(arg_0 -> ((ToolChainSelectorInternal)this.toolChainSelector).canBuild(arg_0));
            if (!targetsCurrentMachine) {
                task.getLogger().warn("'main' component in project '" + project.getPath() + "' cannot build on this machine.");
            }
            return Collections.emptyList();
        }}));
    }

    private Optional<DefaultJvmJarBinary> findJvmBinary(Project project) {
        if (project.getPluginManager().hasPlugin("java")) {
            TaskProvider jvmJarTask = project.getTasks().named("jar", Jar.class);
            return Optional.of(this.getObjects().newInstance(DefaultJvmJarBinary.class, new Object[]{jvmJarTask}));
        }
        return Optional.empty();
    }

    private static Set<DefaultOperatingSystemFamily> targetMachinesToOperatingSystems(Collection<TargetMachine> targetMachines) {
        return targetMachines.stream().map(it -> ((DefaultTargetMachine)it).getOperatingSystemFamily()).collect(Collectors.toSet());
    }

    private static Set<DefaultMachineArchitecture> targetMachinesToArchitectures(Collection<TargetMachine> targetMachines) {
        return targetMachines.stream().map(it -> ((DefaultTargetMachine)it).getArchitecture()).collect(Collectors.toSet());
    }

    private static DefaultTargetMachineFactory registerTargetMachineFactoryAsExtension(ExtensionContainer extensions) {
        DefaultTargetMachineFactory targetMachineFactory = new DefaultTargetMachineFactory();
        extensions.add(TargetMachineFactory.class, "machines", (Object)targetMachineFactory);
        return targetMachineFactory;
    }

    @Inject
    protected abstract ToolChainSelector getToolChainSelector();

    @Inject
    protected abstract ObjectFactory getObjects();

    private static void assertNonEmpty(Collection<?> values, String propertyName, String componentName) {
        if (values.isEmpty()) {
            throw new IllegalArgumentException(String.format("A %s needs to be specified for the %s.", propertyName, componentName));
        }
    }

    private void assertTargetMachinesAreKnown(Collection<TargetMachine> targetMachines) {
        List unknownTargetMachines = targetMachines.stream().filter(it -> !this.toolChainSelector.isKnown(it)).collect(Collectors.toList());
        if (!unknownTargetMachines.isEmpty()) {
            throw new IllegalArgumentException("The following target machines are not know by the defined tool chains:\n" + unknownTargetMachines.stream().map(it -> " * " + ((DefaultOperatingSystemFamily)it.getOperatingSystemFamily()).getName() + " " + ((DefaultMachineArchitecture)it.getArchitecture()).getName()).collect(Collectors.joining("\n")));
        }
    }

    private JniLibraryExtensionInternal registerExtension(Project project, DefaultTargetMachineFactory targetMachineFactory) {
        JniLibraryDependenciesInternal dependencies = (JniLibraryDependenciesInternal)project.getObjects().newInstance(JniLibraryDependenciesInternal.class, new Object[0]);
        Configuration jvmApiElements = Optional.ofNullable(project.getConfigurations().findByName("apiElements")).orElseGet(() -> (Configuration)project.getConfigurations().create("apiElements", configuration -> {
            configuration.setCanBeResolved(false);
            configuration.setCanBeConsumed(true);
            configuration.attributes(attributes -> {
                attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)project.getObjects().named(Usage.class, "java-api"));
                attributes.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)project.getObjects().named(LibraryElements.class, "jar"));
            });
        }));
        jvmApiElements.extendsFrom(new Configuration[]{dependencies.getApiDependencies()});
        Configuration jvmRuntimeElements = Optional.ofNullable(project.getConfigurations().findByName("runtimeElements")).orElseGet(() -> (Configuration)project.getConfigurations().create("runtimeElements", configuration -> {
            configuration.setCanBeResolved(false);
            configuration.setCanBeConsumed(true);
            configuration.attributes(attributes -> {
                attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)project.getObjects().named(Usage.class, "java-runtime"));
                attributes.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)project.getObjects().named(LibraryElements.class, "jar"));
            });
        }));
        jvmRuntimeElements.extendsFrom(new Configuration[]{dependencies.getApiDependencies()});
        Object[] objectArray = new Object[2];
        objectArray[0] = dependencies;
        objectArray[1] = GroupId.of(() -> ((Project)project).getGroup());
        JniLibraryExtensionInternal library = (JniLibraryExtensionInternal)project.getObjects().newInstance(JniLibraryExtensionInternal.class, objectArray);
        library.getTargetMachines().convention(Collections.singletonList(targetMachineFactory.host()));
        project.getExtensions().add(JniLibraryExtension.class, "library", (Object)library);
        return library;
    }

    private static boolean isGradleVersionGreaterOrEqualsTo6Dot3() {
        return GradleVersion.current().compareTo(GradleVersion.version((String)"6.3")) >= 0;
    }

    private void registerJniHeaderSourceSet(Project project, JniLibraryExtensionInternal library) {
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        SourceSet main = (SourceSet)sourceSets.getByName("main");
        TaskProvider compileTask = project.getTasks().named(main.getCompileJavaTaskName(), JavaCompile.class, task -> {
            task.getOptions().getHeaderOutputDirectory().convention(project.getLayout().getBuildDirectory().dir("generated/jni-headers"));
            if (!JniLibraryPlugin.isGradleVersionGreaterOrEqualsTo6Dot3()) {
                task.getOutputs().dir((Object)task.getOptions().getHeaderOutputDirectory());
            }
            task.getOptions().setIncremental(JniLibraryPlugin.isGradleVersionGreaterOrEqualsTo6Dot3());
        });
        HeaderExportingSourceSetInternal jniHeaderSourceSet = (HeaderExportingSourceSetInternal)project.getObjects().newInstance(HeaderExportingSourceSetInternal.class, new Object[0]);
        jniHeaderSourceSet.getSource().from(new Object[]{compileTask.flatMap(it -> it.getOptions().getHeaderOutputDirectory())});
        library.getSources().add((Object)jniHeaderSourceSet);
    }

    private void configureJavaJniRuntime(Project project, JniLibraryExtensionInternal library) {
        project.getConfigurations().getByName("implementation").extendsFrom(new Configuration[]{library.getJvmImplementationDependencies()});
        project.getTasks().named("test", Test.class, task -> {
            List files = library.getVariantCollection().stream().map(it -> it.getNativeRuntimeFiles()).collect(Collectors.toList());
            task.dependsOn(new Object[]{files});
            String path = files.stream().flatMap(it -> it.getFiles().stream()).map(it -> it.getParentFile().getAbsolutePath()).collect(Collectors.joining(File.pathSeparator));
            task.systemProperty("java.library.path", (Object)path);
        });
    }
}

