/*
 * Decompiled with CFR 0.152.
 */
package org.gibello.zql.data;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ZTuple {
    private Vector attributes_ = new Vector();
    private Vector values_ = new Vector();
    private Hashtable searchTable_ = new Hashtable();
    private String separator_ = ",";

    public ZTuple() {
    }

    public ZTuple(char separator) {
        this();
        this.separator_ = Character.toString(separator);
    }

    public ZTuple(String colnames) {
        this();
        this.setColnames(colnames);
    }

    public void setColnames(String colnames) {
        StringTokenizer st = new StringTokenizer(colnames, this.separator_);
        while (st.hasMoreTokens()) {
            this.setAtt(st.nextToken().trim(), null);
        }
    }

    public void setRow(String row) {
        String[] tokens = row.split(this.separator_);
        for (int i = 0; i < tokens.length; ++i) {
            try {
                Double d = new Double(tokens[i].trim());
                this.setAtt(this.getAttName(i), d);
                continue;
            }
            catch (Exception e) {
                this.setAtt(this.getAttName(i), tokens[i].trim());
            }
        }
    }

    public void setRow(Vector row) {
        for (int i = 0; i < row.size(); ++i) {
            this.setAtt(this.getAttName(i), row.elementAt(i));
        }
    }

    public void setAtt(String name, Object value) {
        if (name != null) {
            boolean exist = this.searchTable_.containsKey(name);
            if (exist) {
                int i = (Integer)this.searchTable_.get(name);
                this.values_.setElementAt(value, i);
            } else {
                int i = this.attributes_.size();
                this.attributes_.addElement(name);
                this.values_.addElement(value);
                this.searchTable_.put(name, new Integer(i));
            }
        }
    }

    public String getAttName(int index) {
        try {
            return (String)this.attributes_.elementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public int getAttIndex(String name) {
        if (name == null) {
            return -1;
        }
        Integer index = (Integer)this.searchTable_.get(name);
        if (index != null) {
            return index;
        }
        return -1;
    }

    public Object getAttValue(int index) {
        try {
            return this.values_.elementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public Object getAttValue(String name) {
        boolean exist = false;
        if (name != null) {
            exist = this.searchTable_.containsKey(name);
        }
        if (exist) {
            int index = (Integer)this.searchTable_.get(name);
            return this.values_.elementAt(index);
        }
        return null;
    }

    public boolean isAttribute(String attrName) {
        if (attrName != null) {
            return this.searchTable_.containsKey(attrName);
        }
        return false;
    }

    public int getNumAtt() {
        return this.values_.size();
    }

    public String toString() {
        String valueS;
        Object value;
        String attS;
        Object att;
        StringBuffer resp = new StringBuffer();
        resp.append("[");
        if (this.attributes_.size() > 0) {
            att = this.attributes_.elementAt(0);
            attS = att == null ? "(null)" : att.toString();
            value = this.values_.elementAt(0);
            valueS = value == null ? "(null)" : value.toString();
            resp.append(attS + " = " + valueS);
        }
        for (int i = 1; i < this.attributes_.size(); ++i) {
            att = this.attributes_.elementAt(i);
            attS = att == null ? "(null)" : att.toString();
            value = this.values_.elementAt(i);
            valueS = value == null ? "(null)" : value.toString();
            resp.append(", " + attS + " = " + valueS);
        }
        resp.append("]");
        return resp.toString();
    }
}

