/*
 * Decompiled with CFR 0.152.
 */
package org.gibello.zql.data;

import java.sql.SQLException;
import java.util.Vector;
import org.gibello.zql.ZConstant;
import org.gibello.zql.ZExp;
import org.gibello.zql.ZExpression;
import org.gibello.zql.data.ZTuple;

public class ZEval {
    public boolean eval(ZTuple tuple, ZExp exp) throws SQLException {
        if (tuple == null || exp == null) {
            throw new SQLException("ZEval.eval(): null argument or operator");
        }
        if (!(exp instanceof ZExpression)) {
            throw new SQLException("ZEval.eval(): only expressions are supported");
        }
        ZExpression pred = (ZExpression)exp;
        String op = pred.getOperator();
        if (op.equals("AND")) {
            boolean and = true;
            for (int i = 0; i < pred.nbOperands(); ++i) {
                and &= this.eval(tuple, pred.getOperand(i));
            }
            return and;
        }
        if (op.equals("OR")) {
            boolean or = false;
            for (int i = 0; i < pred.nbOperands(); ++i) {
                or |= this.eval(tuple, pred.getOperand(i));
            }
            return or;
        }
        if (op.equals("NOT")) {
            return !this.eval(tuple, pred.getOperand(0));
        }
        if (op.equals("=")) {
            return this.evalCmp(tuple, pred.getOperands()) == 0.0;
        }
        if (op.equals("!=")) {
            return this.evalCmp(tuple, pred.getOperands()) != 0.0;
        }
        if (op.equals("<>")) {
            return this.evalCmp(tuple, pred.getOperands()) != 0.0;
        }
        if (op.equals("#")) {
            throw new SQLException("ZEval.eval(): Operator # not supported");
        }
        if (op.equals(">")) {
            return this.evalCmp(tuple, pred.getOperands()) > 0.0;
        }
        if (op.equals(">=")) {
            return this.evalCmp(tuple, pred.getOperands()) >= 0.0;
        }
        if (op.equals("<")) {
            return this.evalCmp(tuple, pred.getOperands()) < 0.0;
        }
        if (op.equals("<=")) {
            return this.evalCmp(tuple, pred.getOperands()) <= 0.0;
        }
        if (op.equals("BETWEEN") || op.equals("NOT BETWEEN")) {
            ZExpression newexp = new ZExpression("AND", new ZExpression(">=", pred.getOperand(0), pred.getOperand(1)), new ZExpression("<=", pred.getOperand(0), pred.getOperand(2)));
            if (op.equals("NOT BETWEEN")) {
                return !this.eval(tuple, newexp);
            }
            return this.eval(tuple, newexp);
        }
        if (op.equals("LIKE") || op.equals("NOT LIKE")) {
            boolean like = this.evalLike(tuple, pred.getOperands());
            return op.equals("LIKE") ? like : !like;
        }
        if (op.equals("IN") || op.equals("NOT IN")) {
            ZExpression newexp = new ZExpression("OR");
            for (int i = 1; i < pred.nbOperands(); ++i) {
                newexp.addOperand(new ZExpression("=", pred.getOperand(0), pred.getOperand(i)));
            }
            if (op.equals("NOT IN")) {
                return !this.eval(tuple, newexp);
            }
            return this.eval(tuple, newexp);
        }
        if (op.equals("IS NULL")) {
            if (pred.nbOperands() <= 0 || pred.getOperand(0) == null) {
                return true;
            }
            ZExp x = pred.getOperand(0);
            if (x instanceof ZConstant) {
                return ((ZConstant)x).getType() == 1;
            }
            throw new SQLException("ZEval.eval(): can't eval IS (NOT) NULL");
        }
        if (op.equals("IS NOT NULL")) {
            ZExpression x = new ZExpression("IS NULL");
            x.setOperands(pred.getOperands());
            return !this.eval(tuple, x);
        }
        throw new SQLException("ZEval.eval(): Unknown operator " + op);
    }

    double evalCmp(ZTuple tuple, Vector operands) throws SQLException {
        if (operands.size() < 2) {
            throw new SQLException("ZEval.evalCmp(): Trying to compare less than two values");
        }
        if (operands.size() > 2) {
            throw new SQLException("ZEval.evalCmp(): Trying to compare more than two values");
        }
        Object o1 = null;
        Object o2 = null;
        o1 = this.evalExpValue(tuple, (ZExp)operands.elementAt(0));
        o2 = this.evalExpValue(tuple, (ZExp)operands.elementAt(1));
        if (o1 instanceof String || o2 instanceof String) {
            return o1.equals(o2) ? 0 : -1;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            return ((Number)o1).doubleValue() - ((Number)o2).doubleValue();
        }
        throw new SQLException("ZEval.evalCmp(): can't compare (" + o1.toString() + ") with (" + o2.toString() + ")");
    }

    private boolean evalLike(ZTuple tuple, Vector operands) throws SQLException {
        if (operands.size() < 2) {
            throw new SQLException("ZEval.evalCmp(): Trying to compare less than two values");
        }
        if (operands.size() > 2) {
            throw new SQLException("ZEval.evalCmp(): Trying to compare more than two values");
        }
        Object o1 = this.evalExpValue(tuple, (ZExp)operands.elementAt(0));
        Object o2 = this.evalExpValue(tuple, (ZExp)operands.elementAt(1));
        if (o1 instanceof String && o2 instanceof String) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            if (s2.startsWith("%")) {
                return s1.endsWith(s2.substring(1));
            }
            if (s2.endsWith("%")) {
                return s1.startsWith(s2.substring(0, s2.length() - 1));
            }
            return s1.equalsIgnoreCase(s2);
        }
        throw new SQLException("ZEval.evalLike(): LIKE can only compare strings");
    }

    double evalNumericExp(ZTuple tuple, ZExpression exp) throws SQLException {
        if (tuple == null || exp == null || exp.getOperator() == null) {
            throw new SQLException("ZEval.eval(): null argument or operator");
        }
        String op = exp.getOperator();
        Object o1 = this.evalExpValue(tuple, exp.getOperand(0));
        if (!(o1 instanceof Double)) {
            throw new SQLException("ZEval.evalNumericExp(): expression not numeric");
        }
        Double dobj = (Double)o1;
        if (op.equals("+")) {
            double val = dobj;
            for (int i = 1; i < exp.nbOperands(); ++i) {
                Object obj = this.evalExpValue(tuple, exp.getOperand(i));
                val += ((Number)obj).doubleValue();
            }
            return val;
        }
        if (op.equals("-")) {
            double val = dobj;
            if (exp.nbOperands() == 1) {
                return -val;
            }
            for (int i = 1; i < exp.nbOperands(); ++i) {
                Object obj = this.evalExpValue(tuple, exp.getOperand(i));
                val -= ((Number)obj).doubleValue();
            }
            return val;
        }
        if (op.equals("*")) {
            double val = dobj;
            for (int i = 1; i < exp.nbOperands(); ++i) {
                Object obj = this.evalExpValue(tuple, exp.getOperand(i));
                val *= ((Number)obj).doubleValue();
            }
            return val;
        }
        if (op.equals("/")) {
            double val = dobj;
            for (int i = 1; i < exp.nbOperands(); ++i) {
                Object obj = this.evalExpValue(tuple, exp.getOperand(i));
                val /= ((Number)obj).doubleValue();
            }
            return val;
        }
        if (op.equals("**")) {
            double val = dobj;
            for (int i = 1; i < exp.nbOperands(); ++i) {
                Object obj = this.evalExpValue(tuple, exp.getOperand(i));
                val = Math.pow(val, ((Number)obj).doubleValue());
            }
            return val;
        }
        throw new SQLException("ZEval.evalNumericExp(): Unknown operator " + op);
    }

    public Object evalExpValue(ZTuple tuple, ZExp exp) throws SQLException {
        Object o2 = null;
        if (exp instanceof ZConstant) {
            ZConstant c = (ZConstant)exp;
            switch (c.getType()) {
                case 0: {
                    Object o1 = tuple.getAttValue(c.getValue());
                    if (o1 == null) {
                        throw new SQLException("ZEval.evalExpValue(): unknown column " + c.getValue());
                    }
                    try {
                        o2 = new Double(o1.toString());
                    }
                    catch (NumberFormatException e) {
                        o2 = o1;
                    }
                    break;
                }
                case 2: {
                    o2 = new Double(c.getValue());
                    break;
                }
                default: {
                    o2 = c.getValue();
                    break;
                }
            }
        } else if (exp instanceof ZExpression) {
            o2 = new Double(this.evalNumericExp(tuple, (ZExpression)exp));
        }
        return o2;
    }
}

