/*
 * Decompiled with CFR 0.152.
 */
package org.gibello.zql;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Vector;
import org.gibello.zql.ParseException;
import org.gibello.zql.ZExp;
import org.gibello.zql.ZStatement;
import org.gibello.zql.ZUtils;
import org.gibello.zql.ZqlJJParser;

public class ZqlParser {
    ZqlJJParser _parser = null;

    public static void main(String[] args) throws ParseException {
        ZqlParser p = null;
        if (args.length < 1) {
            System.out.println("/* Reading from stdin (exit; to finish) */");
            p = new ZqlParser(System.in);
        } else {
            try {
                p = new ZqlParser(new DataInputStream(new FileInputStream(args[0])));
            }
            catch (FileNotFoundException e) {
                System.out.println("/* File " + args[0] + " not found. Reading from stdin */");
                p = new ZqlParser(System.in);
            }
        }
        if (args.length > 0) {
            System.out.println("/* Reading from " + args[0] + "*/");
        }
        ZStatement st = null;
        while ((st = p.readStatement()) != null) {
            System.out.println(st.toString() + ";");
        }
        System.out.println("exit;");
        System.out.println("/* Parse Successful */");
    }

    public ZqlParser(InputStream in) {
        this.initParser(in);
    }

    public ZqlParser() {
    }

    public void initParser(InputStream in) {
        if (this._parser == null) {
            this._parser = new ZqlJJParser(in);
        } else {
            this._parser.ReInit(in);
        }
    }

    public void addCustomFunction(String fct, int nparm) {
        ZUtils.addCustomFunction(fct, nparm);
    }

    public ZStatement readStatement() throws ParseException {
        if (this._parser == null) {
            throw new ParseException("Parser not initialized: use initParser(InputStream);");
        }
        return this._parser.SQLStatement();
    }

    public Vector readStatements() throws ParseException {
        if (this._parser == null) {
            throw new ParseException("Parser not initialized: use initParser(InputStream);");
        }
        return this._parser.SQLStatements();
    }

    public ZExp readExpression() throws ParseException {
        if (this._parser == null) {
            throw new ParseException("Parser not initialized: use initParser(InputStream);");
        }
        return this._parser.SQLExpression();
    }
}

