/*
 * Decompiled with CFR 0.152.
 */
package org.gibello.zql;

import java.util.Vector;
import org.gibello.zql.ZConstant;
import org.gibello.zql.ZExp;
import org.gibello.zql.ZQuery;
import org.gibello.zql.ZUtils;

public class ZExpression
implements ZExp {
    String op_ = null;
    Vector operands_ = null;

    public ZExpression(String op) {
        this.op_ = new String(op);
    }

    public ZExpression(String op, ZExp o1) {
        this.op_ = new String(op);
        this.addOperand(o1);
    }

    public ZExpression(String op, ZExp o1, ZExp o2) {
        this.op_ = new String(op);
        this.addOperand(o1);
        this.addOperand(o2);
    }

    public String getOperator() {
        return this.op_;
    }

    public void setOperands(Vector v) {
        this.operands_ = v;
    }

    public Vector getOperands() {
        return this.operands_;
    }

    public void addOperand(ZExp o) {
        if (this.operands_ == null) {
            this.operands_ = new Vector();
        }
        this.operands_.addElement(o);
    }

    public ZExp getOperand(int pos) {
        if (this.operands_ == null || pos >= this.operands_.size()) {
            return null;
        }
        return (ZExp)this.operands_.elementAt(pos);
    }

    public int nbOperands() {
        if (this.operands_ == null) {
            return 0;
        }
        return this.operands_.size();
    }

    public String toReversePolish() {
        StringBuffer buf = new StringBuffer("(");
        buf.append(this.op_);
        for (int i = 0; i < this.nbOperands(); ++i) {
            ZExp opr = this.getOperand(i);
            if (opr instanceof ZExpression) {
                buf.append(" " + ((ZExpression)opr).toReversePolish());
                continue;
            }
            if (opr instanceof ZQuery) {
                buf.append(" (" + opr.toString() + ")");
                continue;
            }
            buf.append(" " + opr.toString());
        }
        buf.append(")");
        return buf.toString();
    }

    public String toString() {
        if (this.op_.equals("?")) {
            return this.op_;
        }
        if (ZUtils.isCustomFunction(this.op_) >= 0) {
            return this.formatFunction();
        }
        StringBuffer buf = new StringBuffer();
        if (this.needPar(this.op_)) {
            buf.append("(");
        }
        switch (this.nbOperands()) {
            case 1: {
                ZExp operand = this.getOperand(0);
                if (operand instanceof ZConstant) {
                    if (ZUtils.isAggregate(this.op_)) {
                        buf.append(this.op_ + "(" + operand.toString() + ")");
                        break;
                    }
                    if (this.op_.equals("IS NULL") || this.op_.equals("IS NOT NULL")) {
                        buf.append(operand.toString() + " " + this.op_);
                        break;
                    }
                    if (this.op_.equals(",")) {
                        buf.append(operand.toString());
                        break;
                    }
                    buf.append(this.op_ + " " + operand.toString());
                    break;
                }
                if (operand instanceof ZQuery) {
                    buf.append(this.op_ + " (" + operand.toString() + ")");
                    break;
                }
                if (this.op_.equals("IS NULL") || this.op_.equals("IS NOT NULL")) {
                    buf.append(operand.toString() + " " + this.op_);
                    break;
                }
                if (this.op_.equals(",")) {
                    buf.append(operand.toString());
                    break;
                }
                buf.append(this.op_ + " " + operand.toString());
                break;
            }
            case 3: {
                if (this.op_.toUpperCase().endsWith("BETWEEN")) {
                    buf.append(this.getOperand(0).toString() + " " + this.op_ + " " + this.getOperand(1).toString() + " AND " + this.getOperand(2).toString());
                    break;
                }
            }
            default: {
                boolean in_op = this.op_.equals("IN") || this.op_.equals("NOT IN");
                int nb = this.nbOperands();
                for (int i = 0; i < nb; ++i) {
                    ZExp operand;
                    if (in_op && i == 1) {
                        buf.append(" " + this.op_ + " (");
                    }
                    if ((operand = this.getOperand(i)) instanceof ZQuery && !in_op) {
                        buf.append("(" + operand.toString() + ")");
                    } else {
                        buf.append(operand.toString());
                    }
                    if (i >= nb - 1) continue;
                    if (this.op_.equals(",") || in_op && i > 0) {
                        buf.append(", ");
                        continue;
                    }
                    if (in_op) continue;
                    buf.append(" " + this.op_ + " ");
                }
                if (!in_op) break;
                buf.append(")");
            }
        }
        if (this.needPar(this.op_)) {
            buf.append(")");
        }
        return buf.toString();
    }

    private boolean needPar(String op) {
        String tmp = op.toUpperCase();
        return !tmp.equals("ANY") && !tmp.equals("ALL") && !tmp.equals("UNION") && !ZUtils.isAggregate(tmp);
    }

    private String formatFunction() {
        StringBuffer b = new StringBuffer(this.op_ + "(");
        int nb = this.nbOperands();
        for (int i = 0; i < nb; ++i) {
            b.append(this.getOperand(i).toString() + (i < nb - 1 ? "," : ""));
        }
        b.append(")");
        return b.toString();
    }
}

