/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.graph;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Immutable;
import dev.mccue.guava.base.Function;
import dev.mccue.guava.base.Functions;
import dev.mccue.guava.base.Preconditions;
import dev.mccue.guava.collect.ImmutableMap;
import dev.mccue.guava.collect.Maps;
import dev.mccue.guava.graph.BaseGraph;
import dev.mccue.guava.graph.DirectedGraphConnections;
import dev.mccue.guava.graph.ElementOrder;
import dev.mccue.guava.graph.ElementTypesAreNonnullByDefault;
import dev.mccue.guava.graph.EndpointPair;
import dev.mccue.guava.graph.ForwardingGraph;
import dev.mccue.guava.graph.Graph;
import dev.mccue.guava.graph.GraphBuilder;
import dev.mccue.guava.graph.GraphConnections;
import dev.mccue.guava.graph.GraphConstants;
import dev.mccue.guava.graph.MutableGraph;
import dev.mccue.guava.graph.StandardValueGraph;
import dev.mccue.guava.graph.UndirectedGraphConnections;

@Immutable(containerOf={"N"})
@ElementTypesAreNonnullByDefault
public class ImmutableGraph<N>
extends ForwardingGraph<N> {
    private final BaseGraph<N> backingGraph;

    ImmutableGraph(BaseGraph<N> backingGraph) {
        this.backingGraph = backingGraph;
    }

    public static <N> ImmutableGraph<N> copyOf(Graph<N> graph) {
        return graph instanceof ImmutableGraph ? (ImmutableGraph<N>)graph : new ImmutableGraph<N>(new StandardValueGraph<N, GraphConstants.Presence>(GraphBuilder.from(graph), ImmutableGraph.getNodeConnections(graph), graph.edges().size()));
    }

    @Deprecated
    public static <N> ImmutableGraph<N> copyOf(ImmutableGraph<N> graph) {
        return (ImmutableGraph)Preconditions.checkNotNull(graph);
    }

    @Override
    public ElementOrder<N> incidentEdgeOrder() {
        return ElementOrder.stable();
    }

    private static <N> ImmutableMap<N, GraphConnections<N, GraphConstants.Presence>> getNodeConnections(Graph<N> graph) {
        ImmutableMap.Builder nodeConnections = ImmutableMap.builder();
        for (N node : graph.nodes()) {
            nodeConnections.put(node, ImmutableGraph.connectionsOf(graph, node));
        }
        return nodeConnections.buildOrThrow();
    }

    private static <N> GraphConnections<N, GraphConstants.Presence> connectionsOf(Graph<N> graph, N node) {
        Function edgeValueFn = Functions.constant((Object)((Object)GraphConstants.Presence.EDGE_EXISTS));
        return graph.isDirected() ? DirectedGraphConnections.ofImmutable(node, graph.incidentEdges(node), edgeValueFn) : UndirectedGraphConnections.ofImmutable(Maps.asMap(graph.adjacentNodes(node), (Function)edgeValueFn));
    }

    @Override
    BaseGraph<N> delegate() {
        return this.backingGraph;
    }

    public static class Builder<N> {
        private final MutableGraph<N> mutableGraph;

        Builder(GraphBuilder<N> graphBuilder) {
            this.mutableGraph = graphBuilder.copy().incidentEdgeOrder(ElementOrder.stable()).build();
        }

        @CanIgnoreReturnValue
        public Builder<N> addNode(N node) {
            this.mutableGraph.addNode(node);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<N> putEdge(N nodeU, N nodeV) {
            this.mutableGraph.putEdge(nodeU, nodeV);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<N> putEdge(EndpointPair<N> endpoints) {
            this.mutableGraph.putEdge(endpoints);
            return this;
        }

        public ImmutableGraph<N> build() {
            return ImmutableGraph.copyOf(this.mutableGraph);
        }
    }
}

