/*
 * Decompiled with CFR 0.152.
 */
package masecla.modrinth4j.endpoints.generic;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import masecla.modrinth4j.client.HttpClient;
import masecla.modrinth4j.endpoints.generic.empty.EmptyRequest;
import masecla.modrinth4j.exception.EndpointException;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpMethod;

public abstract class Endpoint<O, I> {
    private HttpClient client;
    private Gson gson;

    public abstract String getEndpoint();

    public boolean isJsonBody() {
        return true;
    }

    public boolean requiresBody() {
        return true;
    }

    protected String getReplacedUrl(I request, Map<String, String> parameters) {
        String url = this.getEndpoint();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            url = url.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return url;
    }

    public CompletableFuture<O> sendRequest(I request) {
        return this.sendRequest(request, new HashMap<String, String>());
    }

    public CompletableFuture<O> sendRequest(I request, Map<String, String> urlParams) {
        String url = this.getReplacedUrl(request, urlParams);
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        if (this.requiresBody() && !this.getRequestClass().getType().equals(EmptyRequest.class) && !this.isJsonBody()) {
            JsonElement jsonBody = this.gson.toJsonTree(request, this.getRequestClass().getType());
            for (Map.Entry entry : jsonBody.getAsJsonObject().entrySet()) {
                if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                    queryParameters.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                    continue;
                }
                queryParameters.put((String)entry.getKey(), ((JsonElement)entry.getValue()).toString());
            }
        }
        return this.client.connect(url, queryParameters).thenApply(c -> {
            if (HttpMethod.permitsRequestBody((String)this.getMethod())) {
                c.method(this.getMethod(), RequestBody.create((String)"", (MediaType)MediaType.parse((String)"application/json; charset=utf-8")));
            } else {
                c.method(this.getMethod(), null);
            }
            if (this.requiresBody() && !this.getRequestClass().getType().equals(EmptyRequest.class)) {
                JsonElement jsonBody = this.gson.toJsonTree(request, this.getRequestClass().getType());
                if (this.isJsonBody()) {
                    c.method(this.getMethod(), RequestBody.create((String)this.gson.toJson(jsonBody), (MediaType)MediaType.parse((String)"application/json; charset=utf-8")));
                }
            }
            Response response = this.executeRequest((Request.Builder)c);
            ResponseBody body = response.body();
            return this.checkBodyForErrors(body);
        });
    }

    protected Response executeRequest(Request.Builder request) {
        return this.client.execute(request);
    }

    protected O checkBodyForErrors(ResponseBody body) {
        if (body.contentLength() != 0L) {
            String bodySrc = body.string();
            JsonElement unparsedObject = null;
            try {
                unparsedObject = (JsonElement)this.gson.fromJson(bodySrc, JsonElement.class);
            }
            catch (Exception e) {
                throw new EndpointException("invalid-json", "Expected JSON response from endpoint, received: " + bodySrc + "");
            }
            if (unparsedObject != null) {
                if (unparsedObject.isJsonObject() && unparsedObject.getAsJsonObject().has("error")) {
                    String error = unparsedObject.getAsJsonObject().get("error").getAsString();
                    String description = unparsedObject.getAsJsonObject().get("description").getAsString();
                    throw new EndpointException(error, description);
                }
                Object object = this.gson.fromJson(unparsedObject, this.getResponseClass().getType());
                return (O)object;
            }
            return null;
        }
        return null;
    }

    protected byte[] readStream(InputStream stream) {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = stream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    protected byte[] readFile(File file) {
        return this.readStream(new FileInputStream(file));
    }

    public String getMethod() {
        return "GET";
    }

    public abstract TypeToken<O> getResponseClass();

    public abstract TypeToken<I> getRequestClass();

    @Generated
    public Endpoint(HttpClient client, Gson gson) {
        this.client = client;
        this.gson = gson;
    }

    @Generated
    public HttpClient getClient() {
        return this.client;
    }

    @Generated
    public Gson getGson() {
        return this.gson;
    }
}

