/*
 * Decompiled with CFR 0.152.
 */
package dev.ludovic.netlib.lapack;

import dev.ludovic.netlib.lapack.F2jLAPACK;
import dev.ludovic.netlib.lapack.JNILAPACK;
import dev.ludovic.netlib.lapack.JavaLAPACK;
import dev.ludovic.netlib.lapack.LAPACK;
import dev.ludovic.netlib.lapack.NativeLAPACK;
import java.util.logging.Level;
import java.util.logging.Logger;

final class InstanceBuilder {
    private static final Logger log = Logger.getLogger(InstanceBuilder.class.getName());
    private static final LAPACK lapack;
    private static final NativeLAPACK nativeLapack;
    private static final JavaLAPACK javaLapack;

    InstanceBuilder() {
    }

    public static LAPACK lapack() {
        return lapack;
    }

    private static NativeLAPACK initializeNative() {
        try {
            return JNILAPACK.getInstance();
        }
        catch (Throwable t) {
            log.log(Level.FINE, "Failed to load implementation from: " + JNILAPACK.class.getName(), t);
            return null;
        }
    }

    public static NativeLAPACK nativeLapack() {
        if (nativeLapack == null) {
            throw new RuntimeException("Unable to load native LAPACK implementation");
        }
        return nativeLapack;
    }

    private static JavaLAPACK initializeJava() {
        return F2jLAPACK.getInstance();
    }

    public static JavaLAPACK javaLapack() {
        return javaLapack;
    }

    static {
        String allowNativeLapack = System.getProperty("dev.ludovic.netlib.lapack.allowNative", "true");
        if (Boolean.parseBoolean(allowNativeLapack)) {
            nativeLapack = InstanceBuilder.initializeNative();
        } else {
            log.info("Skip trying to load native LAPACK implementation because system property dev.ludovic.netlib.lapack.allowNative is " + allowNativeLapack);
            nativeLapack = null;
        }
        javaLapack = InstanceBuilder.initializeJava();
        lapack = nativeLapack != null ? nativeLapack : javaLapack;
        log.info("Using " + lapack.getClass().getName());
    }
}

