/*
 * Decompiled with CFR 0.152.
 */
package dev.ludovic.netlib.lapack;

import dev.ludovic.netlib.lapack.F2jLAPACK;
import dev.ludovic.netlib.lapack.JNILAPACK;
import dev.ludovic.netlib.lapack.JavaLAPACK;
import dev.ludovic.netlib.lapack.LAPACK;
import dev.ludovic.netlib.lapack.NativeLAPACK;
import java.util.logging.Logger;

final class InstanceBuilder {
    private static final Logger log = Logger.getLogger(InstanceBuilder.class.getName());
    private static final LAPACK lapack = InstanceBuilder.getInstanceImpl();
    private static final NativeLAPACK nativeLapack = InstanceBuilder.getNativeInstanceImpl();
    private static final JavaLAPACK javaLapack = InstanceBuilder.getJavaInstanceImpl();

    InstanceBuilder() {
    }

    public static LAPACK getInstance() {
        return lapack;
    }

    private static LAPACK getInstanceImpl() {
        try {
            return NativeLAPACK.getInstance();
        }
        catch (Throwable t) {
            log.warning("Failed to load implementation from:" + NativeLAPACK.class.getName());
            return JavaLAPACK.getInstance();
        }
    }

    public static NativeLAPACK getNativeInstance() {
        return nativeLapack;
    }

    private static NativeLAPACK getNativeInstanceImpl() {
        try {
            return JNILAPACK.getInstance();
        }
        catch (Throwable t) {
            log.warning("Failed to load implementation from:" + JNILAPACK.class.getName());
            throw new RuntimeException("Unable to load native implementation");
        }
    }

    public static JavaLAPACK getJavaInstance() {
        return javaLapack;
    }

    private static JavaLAPACK getJavaInstanceImpl() {
        return F2jLAPACK.getInstance();
    }
}

