/*
 * Decompiled with CFR 0.152.
 */
package dev.ludovic.netlib.blas;

import dev.ludovic.netlib.blas.BLAS;
import dev.ludovic.netlib.blas.JNIBLAS;
import dev.ludovic.netlib.blas.Java11BLAS;
import dev.ludovic.netlib.blas.Java8BLAS;
import dev.ludovic.netlib.blas.JavaBLAS;
import dev.ludovic.netlib.blas.NativeBLAS;
import dev.ludovic.netlib.blas.VectorBLAS;
import java.util.logging.Level;
import java.util.logging.Logger;

final class InstanceBuilder {
    private static final Logger log = Logger.getLogger(InstanceBuilder.class.getName());
    private static final BLAS blas;
    private static final NativeBLAS nativeBlas;
    private static final JavaBLAS javaBlas;

    InstanceBuilder() {
    }

    public static BLAS blas() {
        return blas;
    }

    private static NativeBLAS initializeNative() {
        try {
            return JNIBLAS.getInstance();
        }
        catch (Throwable t) {
            log.log(Level.FINE, "Failed to load implementation from:" + JNIBLAS.class.getName(), t);
            return null;
        }
    }

    public static NativeBLAS nativeBlas() {
        if (nativeBlas == null) {
            throw new RuntimeException("Unable to load native implementation");
        }
        return nativeBlas;
    }

    private static JavaBLAS initializeJava() {
        String[] fullVersion = System.getProperty("java.version").split("[+.\\-]+", 2);
        int major = Integer.parseInt(fullVersion[0]);
        if (major >= 16) {
            try {
                log.finest("trying to return java 16 instance");
                return VectorBLAS.getInstance();
            }
            catch (Throwable t) {
                log.log(Level.FINE, "Failed to load implementation from:" + VectorBLAS.class.getName(), t);
            }
        }
        if (major >= 11) {
            log.finest("return java 11 instance");
            return Java11BLAS.getInstance();
        }
        log.finest("return java 8 instance");
        return Java8BLAS.getInstance();
    }

    public static JavaBLAS javaBlas() {
        return javaBlas;
    }

    static {
        nativeBlas = InstanceBuilder.initializeNative();
        javaBlas = InstanceBuilder.initializeJava();
        blas = nativeBlas != null ? nativeBlas : javaBlas;
        log.info("Using " + blas.getClass().getName());
    }
}

