/*
 * Decompiled with CFR 0.152.
 */
package dev.ludovic.netlib.blas;

import com.github.fommil.netlib.BLAS;
import dev.ludovic.netlib.blas.AbstractBLAS;
import org.netlib.util.doubleW;
import org.netlib.util.floatW;

abstract class NetlibWrapper
extends AbstractBLAS {
    private final BLAS blas;

    protected NetlibWrapper(BLAS _blas) {
        this.blas = _blas;
    }

    @Override
    protected double dasumK(int n, double[] x, int offsetx, int incx) {
        return this.blas.dasum(n, x, offsetx, incx);
    }

    @Override
    protected float sasumK(int n, float[] x, int offsetx, int incx) {
        return this.blas.sasum(n, x, offsetx, incx);
    }

    @Override
    protected void daxpyK(int n, double alpha, double[] x, int offsetx, int incx, double[] y, int offsety, int incy) {
        this.blas.daxpy(n, alpha, x, offsetx, incx, y, offsety, incy);
    }

    @Override
    protected void saxpyK(int n, float alpha, float[] x, int offsetx, int incx, float[] y, int offsety, int incy) {
        this.blas.saxpy(n, alpha, x, offsetx, incx, y, offsety, incy);
    }

    @Override
    protected void dcopyK(int n, double[] x, int offsetx, int incx, double[] y, int offsety, int incy) {
        this.blas.dcopy(n, x, offsetx, incx, y, offsety, incy);
    }

    @Override
    protected void scopyK(int n, float[] x, int offsetx, int incx, float[] y, int offsety, int incy) {
        this.blas.scopy(n, x, offsetx, incx, y, offsety, incy);
    }

    @Override
    protected double ddotK(int n, double[] x, int offsetx, int incx, double[] y, int offsety, int incy) {
        return this.blas.ddot(n, x, offsetx, incx, y, offsety, incy);
    }

    @Override
    protected float sdotK(int n, float[] x, int offsetx, int incx, float[] y, int offsety, int incy) {
        return this.blas.sdot(n, x, offsetx, incx, y, offsety, incy);
    }

    @Override
    protected float sdsdotK(int n, float sb, float[] sx, int _sx_offset, int incx, float[] sy, int _sy_offset, int incy) {
        return this.blas.sdsdot(n, sb, sx, _sx_offset, incx, sy, _sy_offset, incy);
    }

    @Override
    protected void dgbmvK(String trans, int m, int n, int kl, int ku, double alpha, double[] a, int offseta, int lda, double[] x, int offsetx, int incx, double beta, double[] y, int offsety, int incy) {
        this.blas.dgbmv(trans, m, n, kl, ku, alpha, a, offseta, lda, x, offsetx, incx, beta, y, offsety, incy);
    }

    @Override
    protected void sgbmvK(String trans, int m, int n, int kl, int ku, float alpha, float[] a, int offseta, int lda, float[] x, int offsetx, int incx, float beta, float[] y, int offsety, int incy) {
        this.blas.sgbmv(trans, m, n, kl, ku, alpha, a, offseta, lda, x, offsetx, incx, beta, y, offsety, incy);
    }

    @Override
    protected void dgemmK(String transa, String transb, int m, int n, int k, double alpha, double[] a, int offseta, int lda, double[] b, int offsetb, int ldb, double beta, double[] c, int offsetc, int ldc) {
        this.blas.dgemm(transa, transb, m, n, k, alpha, a, offseta, lda, b, offsetb, ldb, beta, c, offsetc, ldc);
    }

    @Override
    protected void sgemmK(String transa, String transb, int m, int n, int k, float alpha, float[] a, int offseta, int lda, float[] b, int offsetb, int ldb, float beta, float[] c, int offsetc, int ldc) {
        this.blas.sgemm(transa, transb, m, n, k, alpha, a, offseta, lda, b, offsetb, ldb, beta, c, offsetc, ldc);
    }

    @Override
    protected void dgemvK(String trans, int m, int n, double alpha, double[] a, int offseta, int lda, double[] x, int offsetx, int incx, double beta, double[] y, int offsety, int incy) {
        this.blas.dgemv(trans, m, n, alpha, a, offseta, lda, x, offsetx, incx, beta, y, offsety, incy);
    }

    @Override
    protected void sgemvK(String trans, int m, int n, float alpha, float[] a, int offseta, int lda, float[] x, int offsetx, int incx, float beta, float[] y, int offsety, int incy) {
        this.blas.sgemv(trans, m, n, alpha, a, offseta, lda, x, offsetx, incx, beta, y, offsety, incy);
    }

    @Override
    protected void dgerK(int m, int n, double alpha, double[] x, int offsetx, int incx, double[] y, int offsety, int incy, double[] a, int offseta, int lda) {
        this.blas.dger(m, n, alpha, x, offsetx, incx, y, offsety, incy, a, offseta, lda);
    }

    @Override
    protected void sgerK(int m, int n, float alpha, float[] x, int offsetx, int incx, float[] y, int offsety, int incy, float[] a, int offseta, int lda) {
        this.blas.sger(m, n, alpha, x, offsetx, incx, y, offsety, incy, a, offseta, lda);
    }

    @Override
    protected double dnrm2K(int n, double[] x, int offsetx, int incx) {
        return this.blas.dnrm2(n, x, offsetx, incx);
    }

    @Override
    protected float snrm2K(int n, float[] x, int offsetx, int incx) {
        return this.blas.snrm2(n, x, offsetx, incx);
    }

    @Override
    protected void drotK(int n, double[] dx, int offsetdx, int incx, double[] dy, int offsetdy, int incy, double c, double s) {
        this.blas.drot(n, dx, offsetdx, incx, dy, offsetdy, incy, c, s);
    }

    @Override
    protected void srotK(int n, float[] sx, int _sx_offset, int incx, float[] sy, int _sy_offset, int incy, float c, float s) {
        this.blas.srot(n, sx, _sx_offset, incx, sy, _sy_offset, incy, c, s);
    }

    @Override
    protected void drotmK(int n, double[] dx, int offsetdx, int incx, double[] dy, int offsetdy, int incy, double[] dparam, int _dparam_offset) {
        this.blas.drotm(n, dx, offsetdx, incx, dy, offsetdy, incy, dparam, _dparam_offset);
    }

    @Override
    protected void srotmK(int n, float[] sx, int _sx_offset, int incx, float[] sy, int _sy_offset, int incy, float[] sparam, int _sparam_offset) {
        this.blas.srotm(n, sx, _sx_offset, incx, sy, _sy_offset, incy, sparam, _sparam_offset);
    }

    @Override
    protected void drotmgK(doubleW dd1, doubleW dd2, doubleW dx1, double dy1, double[] dparam, int _dparam_offset) {
        this.blas.drotmg(dd1, dd2, dx1, dy1, dparam, _dparam_offset);
    }

    @Override
    protected void srotmgK(floatW sd1, floatW sd2, floatW sx1, float sy1, float[] sparam, int _sparam_offset) {
        this.blas.srotmg(sd1, sd2, sx1, sy1, sparam, _sparam_offset);
    }

    @Override
    protected void dsbmvK(String uplo, int n, int k, double alpha, double[] a, int offseta, int lda, double[] x, int offsetx, int incx, double beta, double[] y, int offsety, int incy) {
        this.blas.dsbmv(uplo, n, k, alpha, a, offseta, lda, x, offsetx, incx, beta, y, offsety, incy);
    }

    @Override
    protected void ssbmvK(String uplo, int n, int k, float alpha, float[] a, int offseta, int lda, float[] x, int offsetx, int incx, float beta, float[] y, int offsety, int incy) {
        this.blas.ssbmv(uplo, n, k, alpha, a, offseta, lda, x, offsetx, incx, beta, y, offsety, incy);
    }

    @Override
    protected void dscalK(int n, double alpha, double[] x, int offsetx, int incx) {
        this.blas.dscal(n, alpha, x, offsetx, incx);
    }

    @Override
    protected void sscalK(int n, float alpha, float[] x, int offsetx, int incx) {
        this.blas.sscal(n, alpha, x, offsetx, incx);
    }

    @Override
    protected void dspmvK(String uplo, int n, double alpha, double[] a, int offseta, double[] x, int offsetx, int incx, double beta, double[] y, int offsety, int incy) {
        this.blas.dspmv(uplo, n, alpha, a, offseta, x, offsetx, incx, beta, y, offsety, incy);
    }

    @Override
    protected void sspmvK(String uplo, int n, float alpha, float[] ap, int offsetap, float[] x, int offsetx, int incx, float beta, float[] y, int offsety, int incy) {
        this.blas.sspmv(uplo, n, alpha, ap, offsetap, x, offsetx, incx, beta, y, offsety, incy);
    }

    @Override
    protected void dsprK(String uplo, int n, double alpha, double[] x, int offsetx, int incx, double[] a, int offseta) {
        this.blas.dspr(uplo, n, alpha, x, offsetx, incx, a, offseta);
    }

    @Override
    protected void ssprK(String uplo, int n, float alpha, float[] x, int offsetx, int incx, float[] ap, int offsetap) {
        this.blas.sspr(uplo, n, alpha, x, offsetx, incx, ap, offsetap);
    }

    @Override
    protected void dspr2K(String uplo, int n, double alpha, double[] x, int offsetx, int incx, double[] y, int offsety, int incy, double[] ap, int offsetap) {
        this.blas.dspr2(uplo, n, alpha, x, offsetx, incx, y, offsety, incy, ap, offsetap);
    }

    @Override
    protected void sspr2K(String uplo, int n, float alpha, float[] x, int offsetx, int incx, float[] y, int offsety, int incy, float[] ap, int offsetap) {
        this.blas.sspr2(uplo, n, alpha, x, offsetx, incx, y, offsety, incy, ap, offsetap);
    }

    @Override
    protected void dswapK(int n, double[] x, int offsetx, int incx, double[] y, int offsety, int incy) {
        this.blas.dswap(n, x, offsetx, incx, y, offsety, incy);
    }

    @Override
    protected void sswapK(int n, float[] x, int offsetx, int incx, float[] y, int offsety, int incy) {
        this.blas.sswap(n, x, offsetx, incx, y, offsety, incy);
    }

    @Override
    protected void dsymmK(String side, String uplo, int m, int n, double alpha, double[] a, int offseta, int lda, double[] b, int offsetb, int ldb, double beta, double[] c, int offsetc, int ldc) {
        this.blas.dsymm(side, uplo, m, n, alpha, a, offseta, lda, b, offsetb, ldb, beta, c, offsetc, ldc);
    }

    @Override
    protected void ssymmK(String side, String uplo, int m, int n, float alpha, float[] a, int offseta, int lda, float[] b, int offsetb, int ldb, float beta, float[] c, int offsetc, int ldc) {
        this.blas.ssymm(side, uplo, m, n, alpha, a, offseta, lda, b, offsetb, ldb, beta, c, offsetc, ldc);
    }

    @Override
    protected void dsymvK(String uplo, int n, double alpha, double[] a, int offseta, int lda, double[] x, int offsetx, int incx, double beta, double[] y, int offsety, int incy) {
        this.blas.dsymv(uplo, n, alpha, a, offseta, lda, x, offsetx, incx, beta, y, offsety, incy);
    }

    @Override
    protected void ssymvK(String uplo, int n, float alpha, float[] a, int offseta, int lda, float[] x, int offsetx, int incx, float beta, float[] y, int offsety, int incy) {
        this.blas.ssymv(uplo, n, alpha, a, offseta, lda, x, offsetx, incx, beta, y, offsety, incy);
    }

    @Override
    protected void dsyrK(String uplo, int n, double alpha, double[] x, int offsetx, int incx, double[] a, int offseta, int lda) {
        this.blas.dsyr(uplo, n, alpha, x, offsetx, incx, a, offseta, lda);
    }

    @Override
    protected void ssyrK(String uplo, int n, float alpha, float[] x, int offsetx, int incx, float[] a, int offseta, int lda) {
        this.blas.ssyr(uplo, n, alpha, x, offsetx, incx, a, offseta, lda);
    }

    @Override
    protected void dsyr2K(String uplo, int n, double alpha, double[] x, int offsetx, int incx, double[] y, int offsety, int incy, double[] a, int offseta, int lda) {
        this.blas.dsyr2(uplo, n, alpha, x, offsetx, incx, y, offsety, incy, a, offseta, lda);
    }

    @Override
    protected void ssyr2K(String uplo, int n, float alpha, float[] x, int offsetx, int incx, float[] y, int offsety, int incy, float[] a, int offseta, int lda) {
        this.blas.ssyr2(uplo, n, alpha, x, offsetx, incx, y, offsety, incy, a, offseta, lda);
    }

    @Override
    protected void dsyr2kK(String uplo, String trans, int n, int k, double alpha, double[] a, int offseta, int lda, double[] b, int offsetb, int ldb, double beta, double[] c, int offsetc, int ldc) {
        this.blas.dsyr2k(uplo, trans, n, k, alpha, a, offseta, lda, b, offsetb, ldb, beta, c, offsetc, ldc);
    }

    @Override
    protected void ssyr2kK(String uplo, String trans, int n, int k, float alpha, float[] a, int offseta, int lda, float[] b, int offsetb, int ldb, float beta, float[] c, int offsetc, int ldc) {
        this.blas.ssyr2k(uplo, trans, n, k, alpha, a, offseta, lda, b, offsetb, ldb, beta, c, offsetc, ldc);
    }

    @Override
    protected void dsyrkK(String uplo, String trans, int n, int k, double alpha, double[] a, int offseta, int lda, double beta, double[] c, int offsetc, int ldc) {
        this.blas.dsyrk(uplo, trans, n, k, alpha, a, offseta, lda, beta, c, offsetc, ldc);
    }

    @Override
    protected void ssyrkK(String uplo, String trans, int n, int k, float alpha, float[] a, int offseta, int lda, float beta, float[] c, int offsetc, int ldc) {
        this.blas.ssyrk(uplo, trans, n, k, alpha, a, offseta, lda, beta, c, offsetc, ldc);
    }

    @Override
    protected void dtbmvK(String uplo, String trans, String diag, int n, int k, double[] a, int offseta, int lda, double[] x, int offsetx, int incx) {
        this.blas.dtbmv(uplo, trans, diag, n, k, a, offseta, lda, x, offsetx, incx);
    }

    @Override
    protected void stbmvK(String uplo, String trans, String diag, int n, int k, float[] a, int offseta, int lda, float[] x, int offsetx, int incx) {
        this.blas.stbmv(uplo, trans, diag, n, k, a, offseta, lda, x, offsetx, incx);
    }

    @Override
    protected void dtbsvK(String uplo, String trans, String diag, int n, int k, double[] a, int offseta, int lda, double[] x, int offsetx, int incx) {
        this.blas.dtbsv(uplo, trans, diag, n, k, a, offseta, lda, x, offsetx, incx);
    }

    @Override
    protected void stbsvK(String uplo, String trans, String diag, int n, int k, float[] a, int offseta, int lda, float[] x, int offsetx, int incx) {
        this.blas.stbsv(uplo, trans, diag, n, k, a, offseta, lda, x, offsetx, incx);
    }

    @Override
    protected void dtpmvK(String uplo, String trans, String diag, int n, double[] ap, int offsetap, double[] x, int offsetx, int incx) {
        this.blas.dtpmv(uplo, trans, diag, n, ap, offsetap, x, offsetx, incx);
    }

    @Override
    protected void stpmvK(String uplo, String trans, String diag, int n, float[] ap, int offsetap, float[] x, int offsetx, int incx) {
        this.blas.stpmv(uplo, trans, diag, n, ap, offsetap, x, offsetx, incx);
    }

    @Override
    protected void dtpsvK(String uplo, String trans, String diag, int n, double[] ap, int offsetap, double[] x, int offsetx, int incx) {
        this.blas.dtpsv(uplo, trans, diag, n, ap, offsetap, x, offsetx, incx);
    }

    @Override
    protected void stpsvK(String uplo, String trans, String diag, int n, float[] ap, int offsetap, float[] x, int offsetx, int incx) {
        this.blas.stpsv(uplo, trans, diag, n, ap, offsetap, x, offsetx, incx);
    }

    @Override
    protected void dtrmmK(String side, String uplo, String transa, String diag, int m, int n, double alpha, double[] a, int offseta, int lda, double[] b, int offsetb, int ldb) {
        this.blas.dtrmm(side, uplo, transa, diag, m, n, alpha, a, offseta, lda, b, offsetb, ldb);
    }

    @Override
    protected void strmmK(String side, String uplo, String transa, String diag, int m, int n, float alpha, float[] a, int offseta, int lda, float[] b, int offsetb, int ldb) {
        this.blas.strmm(side, uplo, transa, diag, m, n, alpha, a, offseta, lda, b, offsetb, ldb);
    }

    @Override
    protected void dtrmvK(String uplo, String trans, String diag, int n, double[] a, int offseta, int lda, double[] x, int offsetx, int incx) {
        this.blas.dtrmv(uplo, trans, diag, n, a, offseta, lda, x, offsetx, incx);
    }

    @Override
    protected void strmvK(String uplo, String trans, String diag, int n, float[] a, int offseta, int lda, float[] x, int offsetx, int incx) {
        this.blas.strmv(uplo, trans, diag, n, a, offseta, lda, x, offsetx, incx);
    }

    @Override
    protected void dtrsmK(String side, String uplo, String transa, String diag, int m, int n, double alpha, double[] a, int offseta, int lda, double[] b, int offsetb, int ldb) {
        this.blas.dtrsm(side, uplo, transa, diag, m, n, alpha, a, offseta, lda, b, offsetb, ldb);
    }

    @Override
    protected void strsmK(String side, String uplo, String transa, String diag, int m, int n, float alpha, float[] a, int offseta, int lda, float[] b, int offsetb, int ldb) {
        this.blas.strsm(side, uplo, transa, diag, m, n, alpha, a, offseta, lda, b, offsetb, ldb);
    }

    @Override
    protected void dtrsvK(String uplo, String trans, String diag, int n, double[] a, int offseta, int lda, double[] x, int offsetx, int incx) {
        this.blas.dtrsv(uplo, trans, diag, n, a, offseta, lda, x, offsetx, incx);
    }

    @Override
    protected void strsvK(String uplo, String trans, String diag, int n, float[] a, int offseta, int lda, float[] x, int offsetx, int incx) {
        this.blas.strsv(uplo, trans, diag, n, a, offseta, lda, x, offsetx, incx);
    }

    @Override
    protected int idamaxK(int n, double[] x, int offsetx, int incx) {
        return this.blas.idamax(n, x, offsetx, incx);
    }

    @Override
    protected int isamaxK(int n, float[] sx, int _sx_offset, int incx) {
        return this.blas.isamax(n, sx, _sx_offset, incx);
    }
}

