/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.pgvector;

import dev.langchain4j.store.embedding.filter.Filter;
import dev.langchain4j.store.embedding.filter.comparison.IsEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsGreaterThan;
import dev.langchain4j.store.embedding.filter.comparison.IsGreaterThanOrEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsIn;
import dev.langchain4j.store.embedding.filter.comparison.IsLessThan;
import dev.langchain4j.store.embedding.filter.comparison.IsLessThanOrEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsNotEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsNotIn;
import dev.langchain4j.store.embedding.filter.logical.And;
import dev.langchain4j.store.embedding.filter.logical.Not;
import dev.langchain4j.store.embedding.filter.logical.Or;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

abstract class PgVectorFilterMapper {
    static final Map<Class<?>, String> SQL_TYPE_MAP = Stream.of(new AbstractMap.SimpleEntry<Class<Integer>, String>(Integer.class, "int"), new AbstractMap.SimpleEntry<Class<Long>, String>(Long.class, "bigint"), new AbstractMap.SimpleEntry<Class<Float>, String>(Float.class, "float"), new AbstractMap.SimpleEntry<Class<Double>, String>(Double.class, "float8"), new AbstractMap.SimpleEntry<Class<String>, String>(String.class, "text"), new AbstractMap.SimpleEntry<Class<UUID>, String>(UUID.class, "uuid"), new AbstractMap.SimpleEntry<Class<Boolean>, String>(Boolean.class, "boolean"), new AbstractMap.SimpleEntry<Class<Object>, String>(Object.class, "text")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));

    PgVectorFilterMapper() {
    }

    public String map(Filter filter) {
        if (filter instanceof IsEqualTo) {
            return this.mapEqual((IsEqualTo)filter);
        }
        if (filter instanceof IsNotEqualTo) {
            return this.mapNotEqual((IsNotEqualTo)filter);
        }
        if (filter instanceof IsGreaterThan) {
            return this.mapGreaterThan((IsGreaterThan)filter);
        }
        if (filter instanceof IsGreaterThanOrEqualTo) {
            return this.mapGreaterThanOrEqual((IsGreaterThanOrEqualTo)filter);
        }
        if (filter instanceof IsLessThan) {
            return this.mapLessThan((IsLessThan)filter);
        }
        if (filter instanceof IsLessThanOrEqualTo) {
            return this.mapLessThanOrEqual((IsLessThanOrEqualTo)filter);
        }
        if (filter instanceof IsIn) {
            return this.mapIn((IsIn)filter);
        }
        if (filter instanceof IsNotIn) {
            return this.mapNotIn((IsNotIn)filter);
        }
        if (filter instanceof And) {
            return this.mapAnd((And)filter);
        }
        if (filter instanceof Not) {
            return this.mapNot((Not)filter);
        }
        if (filter instanceof Or) {
            return this.mapOr((Or)filter);
        }
        throw new UnsupportedOperationException("Unsupported filter type: " + filter.getClass().getName());
    }

    private String mapEqual(IsEqualTo isEqualTo) {
        String key = this.formatKey(isEqualTo.key(), isEqualTo.comparisonValue().getClass());
        return String.format("%s is not null and %s = %s", key, key, this.formatValue(isEqualTo.comparisonValue()));
    }

    private String mapNotEqual(IsNotEqualTo isNotEqualTo) {
        String key = this.formatKey(isNotEqualTo.key(), isNotEqualTo.comparisonValue().getClass());
        return String.format("%s is null or %s != %s", key, key, this.formatValue(isNotEqualTo.comparisonValue()));
    }

    private String mapGreaterThan(IsGreaterThan isGreaterThan) {
        return String.format("%s > %s", this.formatKey(isGreaterThan.key(), isGreaterThan.comparisonValue().getClass()), this.formatValue(isGreaterThan.comparisonValue()));
    }

    private String mapGreaterThanOrEqual(IsGreaterThanOrEqualTo isGreaterThanOrEqualTo) {
        return String.format("%s >= %s", this.formatKey(isGreaterThanOrEqualTo.key(), isGreaterThanOrEqualTo.comparisonValue().getClass()), this.formatValue(isGreaterThanOrEqualTo.comparisonValue()));
    }

    private String mapLessThan(IsLessThan isLessThan) {
        return String.format("%s < %s", this.formatKey(isLessThan.key(), isLessThan.comparisonValue().getClass()), this.formatValue(isLessThan.comparisonValue()));
    }

    private String mapLessThanOrEqual(IsLessThanOrEqualTo isLessThanOrEqualTo) {
        return String.format("%s <= %s", this.formatKey(isLessThanOrEqualTo.key(), isLessThanOrEqualTo.comparisonValue().getClass()), this.formatValue(isLessThanOrEqualTo.comparisonValue()));
    }

    private String mapIn(IsIn isIn) {
        return String.format("%s in %s", this.formatKeyAsString(isIn.key()), this.formatValuesAsString(isIn.comparisonValues()));
    }

    private String mapNotIn(IsNotIn isNotIn) {
        String key = this.formatKeyAsString(isNotIn.key());
        return String.format("%s is null or %s not in %s", key, key, this.formatValuesAsString(isNotIn.comparisonValues()));
    }

    private String mapAnd(And and) {
        return String.format("%s and %s", this.map(and.left()), this.map(and.right()));
    }

    private String mapNot(Not not) {
        return String.format("not(%s)", this.map(not.expression()));
    }

    private String mapOr(Or or) {
        return String.format("(%s or %s)", this.map(or.left()), this.map(or.right()));
    }

    abstract String formatKey(String var1, Class<?> var2);

    abstract String formatKeyAsString(String var1);

    String formatValue(Object value) {
        if (value instanceof String || value instanceof UUID) {
            return "'" + String.valueOf(value) + "'";
        }
        return value.toString();
    }

    String formatValuesAsString(Collection<?> values) {
        return "(" + values.stream().map((? super T v) -> String.format("'%s'", v)).collect(Collectors.joining(",")) + ")";
    }
}

