/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.pgvector;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.pgvector.PGvector;
import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingStore;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgVectorEmbeddingStore
implements EmbeddingStore<TextSegment> {
    private static final Logger log = LoggerFactory.getLogger(PgVectorEmbeddingStore.class);
    private static final Gson GSON = new Gson();
    private final String host;
    private final Integer port;
    private final String user;
    private final String password;
    private final String database;
    private final String table;

    public PgVectorEmbeddingStore(String host, Integer port, String user, String password, String database, String table, Integer dimension, Boolean useIndex, Integer indexListSize, Boolean createTable, Boolean dropTableFirst) {
        this.host = ValidationUtils.ensureNotBlank((String)host, (String)"host");
        this.port = ValidationUtils.ensureGreaterThanZero((Integer)port, (String)"port");
        this.user = ValidationUtils.ensureNotBlank((String)user, (String)"user");
        this.password = ValidationUtils.ensureNotBlank((String)password, (String)"password");
        this.database = ValidationUtils.ensureNotBlank((String)database, (String)"database");
        this.table = ValidationUtils.ensureNotBlank((String)table, (String)"table");
        useIndex = (Boolean)Utils.getOrDefault((Object)useIndex, (Object)false);
        createTable = (Boolean)Utils.getOrDefault((Object)createTable, (Object)true);
        dropTableFirst = (Boolean)Utils.getOrDefault((Object)dropTableFirst, (Object)false);
        try (Connection connection = this.setupConnection();){
            if (dropTableFirst.booleanValue()) {
                connection.createStatement().executeUpdate(String.format("DROP TABLE IF EXISTS %s", table));
            }
            if (createTable.booleanValue()) {
                connection.createStatement().executeUpdate(String.format("CREATE TABLE IF NOT EXISTS %s (embedding_id UUID PRIMARY KEY, embedding vector(%s), text TEXT NULL, metadata JSON NULL)", table, ValidationUtils.ensureGreaterThanZero((Integer)dimension, (String)"dimension")));
            }
            if (useIndex.booleanValue()) {
                String indexName = table + "_ivfflat_index";
                connection.createStatement().executeUpdate(String.format("CREATE INDEX IF NOT EXISTS %s ON %s USING ivfflat (embedding vector_cosine_ops) WITH (lists = %s)", indexName, table, ValidationUtils.ensureGreaterThanZero((Integer)indexListSize, (String)"indexListSize")));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private Connection setupConnection() throws SQLException {
        Connection connection = DriverManager.getConnection(String.format("jdbc:postgresql://%s:%s/%s", this.host, this.port, this.database), this.user, this.password);
        connection.createStatement().executeUpdate("CREATE EXTENSION IF NOT EXISTS vector");
        PGvector.addVectorType((Connection)connection);
        return connection;
    }

    public String add(Embedding embedding) {
        String id = Utils.randomUUID();
        this.addInternal(id, embedding, null);
        return id;
    }

    public void add(String id, Embedding embedding) {
        this.addInternal(id, embedding, null);
    }

    public String add(Embedding embedding, TextSegment textSegment) {
        String id = Utils.randomUUID();
        this.addInternal(id, embedding, textSegment);
        return id;
    }

    public List<String> addAll(List<Embedding> embeddings) {
        List<String> ids = embeddings.stream().map(ignored -> Utils.randomUUID()).collect(Collectors.toList());
        this.addAllInternal(ids, embeddings, null);
        return ids;
    }

    public List<String> addAll(List<Embedding> embeddings, List<TextSegment> embedded) {
        List<String> ids = embeddings.stream().map(ignored -> Utils.randomUUID()).collect(Collectors.toList());
        this.addAllInternal(ids, embeddings, embedded);
        return ids;
    }

    public List<EmbeddingMatch<TextSegment>> findRelevant(Embedding referenceEmbedding, int maxResults, double minScore) {
        ArrayList<EmbeddingMatch<TextSegment>> result = new ArrayList<EmbeddingMatch<TextSegment>>();
        try (Connection connection = this.setupConnection();){
            String referenceVector = Arrays.toString(referenceEmbedding.vector());
            String query = String.format("WITH temp AS (SELECT (2 - (embedding <=> '%s')) / 2 AS score, embedding_id, embedding, text, metadata FROM %s) SELECT * FROM temp WHERE score >= %s ORDER BY score desc LIMIT %s;", referenceVector, this.table, minScore, maxResults);
            PreparedStatement selectStmt = connection.prepareStatement(query);
            ResultSet resultSet = selectStmt.executeQuery();
            while (resultSet.next()) {
                double score = resultSet.getDouble("score");
                String embeddingId = resultSet.getString("embedding_id");
                PGvector vector = (PGvector)resultSet.getObject("embedding");
                Embedding embedding = new Embedding(vector.toArray());
                String text = resultSet.getString("text");
                TextSegment textSegment = null;
                if (Utils.isNotNullOrBlank((String)text)) {
                    String metadataJson = Optional.ofNullable(resultSet.getString("metadata")).orElse("{}");
                    Type type = new TypeToken<Map<String, String>>(){}.getType();
                    Metadata metadata = new Metadata(new HashMap((Map)GSON.fromJson(metadataJson, type)));
                    textSegment = TextSegment.from((String)text, (Metadata)metadata);
                }
                result.add((EmbeddingMatch<TextSegment>)new EmbeddingMatch(Double.valueOf(score), embeddingId, embedding, textSegment));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private void addInternal(String id, Embedding embedding, TextSegment embedded) {
        this.addAllInternal(Collections.singletonList(id), Collections.singletonList(embedding), embedded == null ? null : Collections.singletonList(embedded));
    }

    private void addAllInternal(List<String> ids, List<Embedding> embeddings, List<TextSegment> embedded) {
        if (Utils.isNullOrEmpty(ids) || Utils.isNullOrEmpty(embeddings)) {
            log.info("Empty embeddings - no ops");
            return;
        }
        ValidationUtils.ensureTrue((ids.size() == embeddings.size() ? 1 : 0) != 0, (String)"ids size is not equal to embeddings size");
        ValidationUtils.ensureTrue((embedded == null || embeddings.size() == embedded.size() ? 1 : 0) != 0, (String)"embeddings size is not equal to embedded size");
        try (Connection connection = this.setupConnection();){
            String query = String.format("INSERT INTO %s (embedding_id, embedding, text, metadata) VALUES (?, ?, ?, ?)ON CONFLICT (embedding_id) DO UPDATE SET embedding = EXCLUDED.embedding,text = EXCLUDED.text,metadata = EXCLUDED.metadata;", this.table);
            PreparedStatement upsertStmt = connection.prepareStatement(query);
            for (int i = 0; i < ids.size(); ++i) {
                upsertStmt.setObject(1, UUID.fromString(ids.get(i)));
                upsertStmt.setObject(2, new PGvector(embeddings.get(i).vector()));
                if (embedded != null && embedded.get(i) != null) {
                    upsertStmt.setObject(3, embedded.get(i).text());
                    Map metadata = embedded.get(i).metadata().asMap();
                    upsertStmt.setObject(4, (Object)GSON.toJson((Object)metadata), 1111);
                } else {
                    upsertStmt.setNull(3, 12);
                    upsertStmt.setNull(4, 1111);
                }
                upsertStmt.addBatch();
            }
            upsertStmt.executeBatch();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static PgVectorEmbeddingStoreBuilder builder() {
        return new PgVectorEmbeddingStoreBuilder();
    }

    public static class PgVectorEmbeddingStoreBuilder {
        private String host;
        private Integer port;
        private String user;
        private String password;
        private String database;
        private String table;
        private Integer dimension;
        private Boolean useIndex;
        private Integer indexListSize;
        private Boolean createTable;
        private Boolean dropTableFirst;

        PgVectorEmbeddingStoreBuilder() {
        }

        public PgVectorEmbeddingStoreBuilder host(String host) {
            this.host = host;
            return this;
        }

        public PgVectorEmbeddingStoreBuilder port(Integer port) {
            this.port = port;
            return this;
        }

        public PgVectorEmbeddingStoreBuilder user(String user) {
            this.user = user;
            return this;
        }

        public PgVectorEmbeddingStoreBuilder password(String password) {
            this.password = password;
            return this;
        }

        public PgVectorEmbeddingStoreBuilder database(String database) {
            this.database = database;
            return this;
        }

        public PgVectorEmbeddingStoreBuilder table(String table) {
            this.table = table;
            return this;
        }

        public PgVectorEmbeddingStoreBuilder dimension(Integer dimension) {
            this.dimension = dimension;
            return this;
        }

        public PgVectorEmbeddingStoreBuilder useIndex(Boolean useIndex) {
            this.useIndex = useIndex;
            return this;
        }

        public PgVectorEmbeddingStoreBuilder indexListSize(Integer indexListSize) {
            this.indexListSize = indexListSize;
            return this;
        }

        public PgVectorEmbeddingStoreBuilder createTable(Boolean createTable) {
            this.createTable = createTable;
            return this;
        }

        public PgVectorEmbeddingStoreBuilder dropTableFirst(Boolean dropTableFirst) {
            this.dropTableFirst = dropTableFirst;
            return this;
        }

        public PgVectorEmbeddingStore build() {
            return new PgVectorEmbeddingStore(this.host, this.port, this.user, this.password, this.database, this.table, this.dimension, this.useIndex, this.indexListSize, this.createTable, this.dropTableFirst);
        }

        public String toString() {
            return "PgVectorEmbeddingStore.PgVectorEmbeddingStoreBuilder(host=" + this.host + ", port=" + this.port + ", user=" + this.user + ", password=" + this.password + ", database=" + this.database + ", table=" + this.table + ", dimension=" + this.dimension + ", useIndex=" + this.useIndex + ", indexListSize=" + this.indexListSize + ", createTable=" + this.createTable + ", dropTableFirst=" + this.dropTableFirst + ")";
        }
    }
}

