/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.http.client.apache;

import dev.langchain4j.exception.HttpException;
import dev.langchain4j.exception.TimeoutException;
import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.http.client.HttpRequest;
import dev.langchain4j.http.client.SuccessfulHttpResponse;
import dev.langchain4j.http.client.apache.ApacheHttpClientBuilder;
import dev.langchain4j.http.client.apache.MultipartBodyPublisher;
import dev.langchain4j.http.client.sse.ServerSentEventListener;
import dev.langchain4j.http.client.sse.ServerSentEventListenerUtils;
import dev.langchain4j.http.client.sse.ServerSentEventParser;
import dev.langchain4j.internal.Utils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.util.Timeout;

public class ApacheHttpClient
implements HttpClient {
    private final CloseableHttpClient syncClient;
    private final CloseableHttpAsyncClient asyncClient;

    public ApacheHttpClient(ApacheHttpClientBuilder builder) {
        HttpClientBuilder syncHttpClientBuilder = (HttpClientBuilder)Utils.getOrDefault((Object)builder.httpClientBuilder(), HttpClients::custom);
        HttpAsyncClientBuilder asyncHttpClientBuilder = (HttpAsyncClientBuilder)Utils.getOrDefault((Object)builder.httpAsyncClientBuilder(), HttpAsyncClients::custom);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        if (builder.connectTimeout() != null) {
            requestConfigBuilder.setConnectionRequestTimeout(Timeout.ofMilliseconds((long)builder.connectTimeout().toMillis()));
        }
        if (builder.readTimeout() != null) {
            requestConfigBuilder.setResponseTimeout(Timeout.ofMilliseconds((long)builder.readTimeout().toMillis()));
        }
        RequestConfig requestConfig = requestConfigBuilder.build();
        asyncHttpClientBuilder.setDefaultRequestConfig(requestConfig);
        syncHttpClientBuilder.setDefaultRequestConfig(requestConfig);
        this.syncClient = syncHttpClientBuilder.build();
        this.asyncClient = asyncHttpClientBuilder.build();
        this.asyncClient.start();
    }

    public static ApacheHttpClientBuilder builder() {
        return new ApacheHttpClientBuilder();
    }

    public SuccessfulHttpResponse execute(HttpRequest request) throws HttpException {
        try {
            ClassicHttpRequest apacheRequest = this.toApacheRequest(request);
            return (SuccessfulHttpResponse)this.syncClient.execute(apacheRequest, classicHttpResponse -> {
                if (!this.isSuccessful((HttpResponse)classicHttpResponse)) {
                    throw new HttpException(classicHttpResponse.getCode(), this.readBody((HttpEntityContainer)classicHttpResponse));
                }
                return this.fromApacheResponse(classicHttpResponse);
            });
        }
        catch (SocketTimeoutException e) {
            throw new TimeoutException((Throwable)e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void execute(HttpRequest request, final ServerSentEventParser parser, final ServerSentEventListener listener) {
        SimpleHttpRequest apacheRequest = this.toSimpleApacheRequest(request);
        this.asyncClient.execute(apacheRequest, (FutureCallback)new FutureCallback<SimpleHttpResponse>(this){
            final /* synthetic */ ApacheHttpClient this$0;
            {
                this.this$0 = this$0;
            }

            public void completed(SimpleHttpResponse apacheResponse) {
                if (!this.this$0.isSuccessful((HttpResponse)apacheResponse)) {
                    HttpException exception = new HttpException(apacheResponse.getCode(), apacheResponse.getBodyText());
                    ServerSentEventListenerUtils.ignoringExceptions(() -> listener.onError((Throwable)exception));
                    return;
                }
                SuccessfulHttpResponse response = this.this$0.fromApacheResponse(apacheResponse);
                ServerSentEventListenerUtils.ignoringExceptions(() -> listener.onOpen(response));
                try (InputStream inputStream = this.this$0.getInputStream(apacheResponse);){
                    parser.parse(inputStream, listener);
                    ServerSentEventListenerUtils.ignoringExceptions(() -> ((ServerSentEventListener)listener).onClose());
                }
                catch (Exception e) {
                    ServerSentEventListenerUtils.ignoringExceptions(() -> listener.onError((Throwable)e));
                }
            }

            public void failed(Exception ex) {
                if (ex instanceof SocketTimeoutException) {
                    ServerSentEventListenerUtils.ignoringExceptions(() -> listener.onError((Throwable)new TimeoutException((Throwable)ex)));
                } else {
                    ServerSentEventListenerUtils.ignoringExceptions(() -> listener.onError((Throwable)ex));
                }
            }

            public void cancelled() {
            }
        });
    }

    private InputStream getInputStream(SimpleHttpResponse apacheResponse) {
        byte[] bodyBytes = apacheResponse.getBody().getBodyBytes();
        return new ByteArrayInputStream(Objects.requireNonNullElseGet(bodyBytes, () -> new byte[0]));
    }

    private SuccessfulHttpResponse fromApacheResponse(ClassicHttpResponse httpResponse) {
        Header[] allHeaders;
        HashMap<String, List> headers = new HashMap<String, List>();
        for (Header header : allHeaders = httpResponse.getHeaders()) {
            headers.computeIfAbsent(header.getName(), k -> new ArrayList()).add(header.getValue());
        }
        return SuccessfulHttpResponse.builder().statusCode(httpResponse.getCode()).headers(headers).body(this.readBody((HttpEntityContainer)httpResponse)).build();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String readBody(HttpEntityContainer httpEntityContainer) {
        try {
            HttpEntity entity = httpEntityContainer.getEntity();
            if (entity == null) {
                return "";
            }
            try (InputStream inputStream = entity.getContent();){
                String string;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                    string = reader.lines().collect(Collectors.joining(System.lineSeparator()));
                }
                return string;
            }
        }
        catch (Exception e) {
            return "Cannot read error response body: " + e.getMessage();
        }
    }

    private boolean isSuccessful(HttpResponse httpResponse) {
        int statusCode = httpResponse.getCode();
        return statusCode >= 200 && statusCode < 300;
    }

    private ClassicHttpRequest toApacheRequest(HttpRequest request) {
        HttpGet apacheRequest;
        switch (request.method()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case GET: {
                HttpGet httpGet = new HttpGet(request.url());
                break;
            }
            case DELETE: {
                HttpGet httpGet = new HttpDelete(request.url());
                break;
            }
            case POST: {
                HttpGet httpGet = apacheRequest = new HttpPost(request.url());
            }
        }
        if (request.formDataFields().isEmpty() && request.formDataFiles().isEmpty()) {
            if (request.body() != null) {
                apacheRequest.setEntity((HttpEntity)new StringEntity(request.body(), ContentType.APPLICATION_JSON));
            }
        } else {
            HttpEntity entity = MultipartBodyPublisher.buildMultipartEntity(request.formDataFields(), request.formDataFiles());
            apacheRequest.setEntity(entity);
        }
        request.headers().forEach((arg_0, arg_1) -> ApacheHttpClient.lambda$toApacheRequest$0((ClassicHttpRequest)apacheRequest, arg_0, arg_1));
        return apacheRequest;
    }

    private SimpleHttpRequest toSimpleApacheRequest(HttpRequest request) {
        SimpleRequestBuilder builder;
        String uri = request.url();
        if (request.formDataFields().isEmpty() && request.formDataFiles().isEmpty()) {
            switch (request.method()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case GET: {
                    SimpleRequestBuilder simpleRequestBuilder = SimpleRequestBuilder.get((String)uri);
                    break;
                }
                case DELETE: {
                    SimpleRequestBuilder simpleRequestBuilder = SimpleRequestBuilder.delete((String)uri);
                    break;
                }
                case POST: {
                    SimpleRequestBuilder simpleRequestBuilder = builder = SimpleRequestBuilder.post((String)uri);
                }
            }
            if (request.body() != null) {
                builder.setBody(request.body(), ContentType.APPLICATION_JSON);
            }
        } else {
            builder = SimpleRequestBuilder.post((String)uri);
            HttpEntity entity = MultipartBodyPublisher.buildMultipartEntity(request.formDataFields(), request.formDataFiles());
            try {
                byte[] bytes = EntityUtils.toByteArray((HttpEntity)entity);
                String contentTypeStr = entity.getContentType();
                ContentType contentType = contentTypeStr != null ? ContentType.parse((CharSequence)contentTypeStr) : ContentType.MULTIPART_FORM_DATA;
                builder.setBody(bytes, contentType);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        request.headers().forEach((name, values) -> {
            if (values != null) {
                for (String value : values) {
                    builder.addHeader(name, value);
                }
            }
        });
        return builder.build();
    }

    private SuccessfulHttpResponse fromApacheResponse(SimpleHttpResponse apacheResponse) {
        Header[] allHeaders;
        HashMap<String, List> headers = new HashMap<String, List>();
        for (Header header : allHeaders = apacheResponse.getHeaders()) {
            headers.computeIfAbsent(header.getName(), k -> new ArrayList()).add(header.getValue());
        }
        String contentType = null;
        for (Header header : allHeaders) {
            if (!"content-type".equalsIgnoreCase(header.getName())) continue;
            contentType = header.getValue();
            break;
        }
        String body = contentType != null && contentType.contains("text/event-stream") ? null : apacheResponse.getBodyText();
        return SuccessfulHttpResponse.builder().statusCode(apacheResponse.getCode()).headers(headers).body(body).build();
    }

    private static /* synthetic */ void lambda$toApacheRequest$0(ClassicHttpRequest apacheRequest, String name, List values) {
        if (values != null) {
            for (String value : values) {
                apacheRequest.addHeader(name, (Object)value);
            }
        }
    }
}

