/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document.parser.apache.tika;

import dev.langchain4j.data.document.BlankDocumentException;
import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentParser;
import dev.langchain4j.internal.Utils;
import java.io.InputStream;
import java.util.function.Supplier;
import org.apache.tika.exception.ZeroByteFileException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;

public class ApacheTikaDocumentParser
implements DocumentParser {
    private static final int NO_WRITE_LIMIT = -1;
    public static final Supplier<Parser> DEFAULT_PARSER_SUPPLIER = AutoDetectParser::new;
    public static final Supplier<Metadata> DEFAULT_METADATA_SUPPLIER = Metadata::new;
    public static final Supplier<ParseContext> DEFAULT_PARSE_CONTEXT_SUPPLIER = ParseContext::new;
    public static final Supplier<ContentHandler> DEFAULT_CONTENT_HANDLER_SUPPLIER = () -> new BodyContentHandler(-1);
    private final Supplier<Parser> parserSupplier;
    private final Supplier<ContentHandler> contentHandlerSupplier;
    private final Supplier<Metadata> metadataSupplier;
    private final Supplier<ParseContext> parseContextSupplier;

    public ApacheTikaDocumentParser() {
        this((Supplier<Parser>)null, null, null, null);
    }

    @Deprecated
    public ApacheTikaDocumentParser(Parser parser, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) {
        this(() -> (Parser)Utils.getOrDefault((Object)parser, DEFAULT_PARSER_SUPPLIER), () -> (ContentHandler)Utils.getOrDefault((Object)contentHandler, DEFAULT_CONTENT_HANDLER_SUPPLIER), () -> (Metadata)Utils.getOrDefault((Object)metadata, DEFAULT_METADATA_SUPPLIER), () -> (ParseContext)Utils.getOrDefault((Object)parseContext, DEFAULT_PARSE_CONTEXT_SUPPLIER));
    }

    public ApacheTikaDocumentParser(Supplier<Parser> parserSupplier, Supplier<ContentHandler> contentHandlerSupplier, Supplier<Metadata> metadataSupplier, Supplier<ParseContext> parseContextSupplier) {
        this.parserSupplier = (Supplier)Utils.getOrDefault(parserSupplier, () -> DEFAULT_PARSER_SUPPLIER);
        this.contentHandlerSupplier = (Supplier)Utils.getOrDefault(contentHandlerSupplier, () -> DEFAULT_CONTENT_HANDLER_SUPPLIER);
        this.metadataSupplier = (Supplier)Utils.getOrDefault(metadataSupplier, () -> DEFAULT_METADATA_SUPPLIER);
        this.parseContextSupplier = (Supplier)Utils.getOrDefault(parseContextSupplier, () -> DEFAULT_PARSE_CONTEXT_SUPPLIER);
    }

    public Document parse(InputStream inputStream) {
        try {
            Parser parser = this.parserSupplier.get();
            ContentHandler contentHandler = this.contentHandlerSupplier.get();
            Metadata metadata = this.metadataSupplier.get();
            ParseContext parseContext = this.parseContextSupplier.get();
            parser.parse(inputStream, contentHandler, metadata, parseContext);
            String text = contentHandler.toString();
            if (Utils.isNullOrBlank((String)text)) {
                throw new BlankDocumentException();
            }
            return Document.from((String)text);
        }
        catch (BlankDocumentException e) {
            throw e;
        }
        catch (ZeroByteFileException e) {
            throw new BlankDocumentException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

