/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document.loader.gcs;

import com.google.api.gax.paging.Page;
import com.google.auth.Credentials;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentLoader;
import dev.langchain4j.data.document.DocumentParser;
import dev.langchain4j.data.document.DocumentSource;
import dev.langchain4j.data.document.source.gcs.GcsSource;
import dev.langchain4j.internal.ValidationUtils;
import java.util.ArrayList;
import java.util.List;

public class GoogleCloudStorageDocumentLoader {
    private final Storage storage;

    private GoogleCloudStorageDocumentLoader(String project, Credentials credentials) {
        StorageOptions.Builder storageBuilder = StorageOptions.newBuilder();
        if (project != null) {
            storageBuilder.setProjectId(ValidationUtils.ensureNotBlank((String)project, (String)"project"));
        }
        if (credentials != null) {
            storageBuilder.setCredentials(credentials);
        }
        this.storage = (Storage)storageBuilder.build().getService();
    }

    public Document loadDocument(String bucket, String objectName, DocumentParser parser) {
        Blob blob = this.storage.get(bucket, objectName, new Storage.BlobGetOption[0]);
        if (blob == null) {
            throw new IllegalArgumentException("Object gs://" + bucket + "/" + objectName + " couldn't be found.");
        }
        GcsSource gcsSource = new GcsSource(blob);
        return DocumentLoader.load((DocumentSource)gcsSource, (DocumentParser)((DocumentParser)ValidationUtils.ensureNotNull((Object)parser, (String)"parser")));
    }

    public List<Document> loadDocuments(String bucket, String globPattern, DocumentParser parser) {
        Page blobs = globPattern != null ? this.storage.list(bucket, new Storage.BlobListOption[]{Storage.BlobListOption.currentDirectory(), Storage.BlobListOption.matchGlob((String)globPattern)}) : this.storage.list(bucket, new Storage.BlobListOption[]{Storage.BlobListOption.currentDirectory()});
        ArrayList<Document> documents = new ArrayList<Document>();
        for (Blob blob : blobs.iterateAll()) {
            GcsSource gcsSource = new GcsSource(blob);
            documents.add(DocumentLoader.load((DocumentSource)gcsSource, (DocumentParser)((DocumentParser)ValidationUtils.ensureNotNull((Object)parser, (String)"parser"))));
        }
        return documents;
    }

    public List<Document> loadDocuments(String bucket, DocumentParser parser) {
        return this.loadDocuments(bucket, null, parser);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String project;
        private Credentials credentials;

        public Builder project(String project) {
            this.project = project;
            return this;
        }

        public Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public GoogleCloudStorageDocumentLoader build() {
            return new GoogleCloudStorageDocumentLoader(this.project, this.credentials);
        }
    }
}

