/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.plugins.backbone;

import dev.hilla.parser.core.AbstractPlugin;
import dev.hilla.parser.core.Node;
import dev.hilla.parser.core.NodeDependencies;
import dev.hilla.parser.core.NodePath;
import dev.hilla.parser.models.MethodInfoModel;
import dev.hilla.parser.models.MethodParameterInfoModel;
import dev.hilla.parser.plugins.backbone.BackbonePluginConfiguration;
import dev.hilla.parser.plugins.backbone.nodes.MethodNode;
import dev.hilla.parser.plugins.backbone.nodes.MethodParameterNode;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class MethodParameterPlugin
extends AbstractPlugin<BackbonePluginConfiguration> {
    public void enter(NodePath<?> nodePath) {
        PathItem pathItem;
        Node node = nodePath.getNode();
        Node parentNode = nodePath.getParentPath().getNode();
        if (node instanceof MethodParameterNode && parentNode instanceof MethodNode && (pathItem = (PathItem)parentNode.getTarget()).getPost().getRequestBody() == null) {
            pathItem.getPost().setRequestBody(this.createRequestBody());
        }
    }

    public void exit(NodePath<?> nodePath) {
    }

    @Nonnull
    public NodeDependencies scan(@Nonnull NodeDependencies nodeDependencies) {
        if (nodeDependencies.getNode() instanceof MethodNode) {
            MethodNode methodNode = (MethodNode)nodeDependencies.getNode();
            return nodeDependencies.appendChildNodes(this.getParametersStream(methodNode));
        }
        return nodeDependencies;
    }

    private RequestBody createRequestBody() {
        ObjectSchema requestMap = new ObjectSchema();
        return new RequestBody().content(new Content().addMediaType("application/json", new MediaType().schema((Schema)requestMap)));
    }

    private Stream<Node<?, ?>> getParametersStream(MethodNode methodNode) {
        ArrayList parameters = new ArrayList(((MethodInfoModel)methodNode.getSource()).getParameters());
        ArrayList<MethodParameterNode> parameterNodes = new ArrayList<MethodParameterNode>(parameters.size());
        for (int i = 0; i < parameters.size(); ++i) {
            MethodParameterInfoModel parameter = (MethodParameterInfoModel)parameters.get(i);
            String name = Optional.ofNullable(((MethodParameterInfoModel)parameters.get(i)).getName()).orElse(String.format("_param_%d", i));
            parameterNodes.add(i, MethodParameterNode.of(parameter, name));
        }
        return parameterNodes.stream();
    }
}

