/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.models.jackson;

import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import dev.hilla.parser.models.AnnotatedAbstractModel;
import dev.hilla.parser.models.AnnotatedModel;
import dev.hilla.parser.models.Model;
import java.util.Optional;

public abstract class JacksonModel<F extends Model, G extends Model, S extends Model>
extends AnnotatedAbstractModel
implements Model,
AnnotatedModel {
    protected final BeanPropertyDefinition origin;
    private Optional<F> field;
    private Optional<G> getter;
    private Optional<S> setter;

    protected JacksonModel(BeanPropertyDefinition origin) {
        this.origin = origin;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JacksonModel)) {
            return false;
        }
        JacksonModel other = (JacksonModel)obj;
        return this.origin.getName().equals(other.origin.getName()) && this.getField().equals(other.getField()) && this.getGetter().equals(other.getGetter()) && this.getSetter().equals(other.getSetter());
    }

    public BeanPropertyDefinition get() {
        return this.origin;
    }

    public Optional<F> getField() {
        if (this.field == null) {
            this.field = Optional.ofNullable(this.prepareField());
        }
        return this.field;
    }

    public Optional<G> getGetter() {
        if (this.getter == null) {
            this.getter = Optional.ofNullable(this.prepareGetter());
        }
        return this.getter;
    }

    public Optional<S> getSetter() {
        if (this.setter == null) {
            this.setter = Optional.ofNullable(this.prepareSetter());
        }
        return this.setter;
    }

    public boolean hasField() {
        return this.origin.hasField();
    }

    public boolean hasGetter() {
        return this.origin.hasGetter();
    }

    public boolean hasSetter() {
        return this.origin.hasSetter();
    }

    public int hashCode() {
        return this.origin.getName().hashCode() + this.getField().hashCode() + this.getGetter().hashCode() + this.getSetter().hashCode() ^ 0x10E6F7B;
    }

    protected abstract F prepareField();

    protected abstract G prepareGetter();

    protected abstract S prepareSetter();
}

