/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.models;

import dev.hilla.parser.models.AnnotatedModel;
import dev.hilla.parser.models.AnnotationInfoModel;
import dev.hilla.parser.models.SignatureModel;
import dev.hilla.parser.models.SourceSignatureModel;
import dev.hilla.parser.models.TypeArgumentModel;
import io.github.classgraph.AnnotationInfoList;
import io.github.classgraph.HierarchicalTypeSignature;
import io.github.classgraph.ReferenceTypeSignature;
import io.github.classgraph.TypeArgument;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class TypeArgumentSourceModel
extends TypeArgumentModel
implements SourceSignatureModel {
    private final TypeArgument origin;

    TypeArgumentSourceModel(TypeArgument origin) {
        this.origin = origin;
    }

    public TypeArgument get() {
        return this.origin;
    }

    @Override
    public TypeArgumentModel.Wildcard getWildcard() {
        switch (this.origin.getWildcard()) {
            case EXTENDS: {
                return TypeArgumentModel.Wildcard.EXTENDS;
            }
            case ANY: {
                return TypeArgumentModel.Wildcard.ANY;
            }
            case SUPER: {
                return TypeArgumentModel.Wildcard.SUPER;
            }
        }
        return TypeArgumentModel.Wildcard.NONE;
    }

    @Override
    protected List<AnnotationInfoModel> prepareAnnotations() {
        AnnotationInfoList annotations = this.origin.getTypeAnnotationInfo();
        return Stream.concat(this.getAssociatedTypes().stream().map(AnnotatedModel::getAnnotations).flatMap(Collection::stream), annotations != null ? annotations.stream().map(AnnotationInfoModel::of) : Stream.empty()).collect(Collectors.toList());
    }

    @Override
    protected List<SignatureModel> prepareAssociatedTypes() {
        ReferenceTypeSignature signature = this.origin.getTypeSignature();
        return signature == null ? List.of() : List.of(SignatureModel.of((HierarchicalTypeSignature)signature));
    }
}

