/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.models;

import dev.hilla.parser.models.AnnotationInfoModel;
import dev.hilla.parser.models.AnnotationParameterModel;
import dev.hilla.parser.models.ClassInfoModel;
import dev.hilla.parser.models.ModelException;
import dev.hilla.parser.models.ReflectionModel;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

final class AnnotationInfoReflectionModel
extends AnnotationInfoModel
implements ReflectionModel {
    private final Annotation origin;

    AnnotationInfoReflectionModel(Annotation origin) {
        this.origin = origin;
    }

    @Override
    public Annotation get() {
        return this.origin;
    }

    @Override
    public String getName() {
        return this.origin.annotationType().getName();
    }

    @Override
    protected Optional<ClassInfoModel> prepareClassInfo() {
        return Optional.of(ClassInfoModel.of(this.origin.annotationType()));
    }

    @Override
    protected Set<AnnotationParameterModel> prepareParameters() {
        return Arrays.stream(this.origin.annotationType().getDeclaredMethods()).map(method -> {
            try {
                Object value = method.invoke((Object)this.origin, new Object[0]);
                boolean isDefault = Objects.deepEquals(method.getDefaultValue(), value);
                return AnnotationParameterModel.of(method.getName(), value, isDefault);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new ModelException(e);
            }
        }).collect(Collectors.toSet());
    }
}

