/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.internal;

import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FallibleCommand;
import dev.hilla.engine.ConfigurationException;
import dev.hilla.engine.EngineConfiguration;
import dev.hilla.engine.commandrunner.CommandRunner;
import dev.hilla.engine.commandrunner.CommandRunnerException;
import dev.hilla.engine.commandrunner.GradleRunner;
import dev.hilla.engine.commandrunner.MavenRunner;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractTaskEndpointGenerator
implements FallibleCommand {
    private static boolean firstRun = true;
    private final String buildDirectoryName;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final File outputDirectory;
    private final File projectDirectory;
    private EngineConfiguration engineConfiguration;

    AbstractTaskEndpointGenerator(File projectDirectory, String buildDirectoryName, File outputDirectory) {
        this.projectDirectory = Objects.requireNonNull(projectDirectory, "Project directory cannot be null");
        this.buildDirectoryName = Objects.requireNonNull(buildDirectoryName, "Build directory name cannot be null");
        this.outputDirectory = Objects.requireNonNull(outputDirectory, "Output direrctory name cannot be null");
    }

    protected EngineConfiguration getEngineConfiguration() throws ExecutionFailedException {
        if (this.engineConfiguration == null) {
            this.prepareEngineConfiguration();
        }
        return this.engineConfiguration;
    }

    protected void prepareEngineConfiguration() throws ExecutionFailedException {
        Path configDir = this.projectDirectory.toPath().resolve(this.buildDirectoryName);
        if (firstRun) {
            this.logger.info("Configure Hilla engine using build system plugin");
            try {
                ((CommandRunner)MavenRunner.forProject((File)this.projectDirectory, (String[])new String[]{"-q", "hilla:configure"}).or(() -> GradleRunner.forProject((File)this.projectDirectory, (String[])new String[]{"-q", "hillaConfigure"})).orElseThrow(() -> new IllegalStateException(String.format("Failed to determine project directory for dev mode. Directory '%s' does not look like a Maven or Gradle project.", this.projectDirectory)))).run(null);
                firstRun = false;
            }
            catch (CommandRunnerException e) {
                throw new ExecutionFailedException("Failed to configure Hilla engine", (Throwable)e);
            }
        }
        try {
            EngineConfiguration config = EngineConfiguration.loadDirectory((Path)configDir);
            if (config == null) {
                throw new ExecutionFailedException("Engine configuration is missing");
            }
            this.engineConfiguration = new EngineConfiguration.Builder(config).outputDir(this.outputDirectory.toPath()).create();
        }
        catch (ConfigurationException | IOException e) {
            throw new ExecutionFailedException("Failed to read Hilla engine configuration", e);
        }
    }
}

