/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema.providers;

import dev.harrel.jsonschema.SimpleType;
import dev.harrel.jsonschema.providers.AbstractJsonNode;
import java.math.BigDecimal;
import java.math.BigInteger;

abstract class SimpleJsonNode
extends AbstractJsonNode<Object> {
    SimpleJsonNode(Object node, String jsonPointer) {
        super(node, jsonPointer);
    }

    abstract boolean isNull(Object var1);

    abstract boolean isArray(Object var1);

    abstract boolean isObject(Object var1);

    @Override
    SimpleType computeNodeType(Object node) {
        if (this.isNull(node)) {
            return SimpleType.NULL;
        }
        if (this.isBoolean(node)) {
            this.rawNode = node;
            return SimpleType.BOOLEAN;
        }
        if (this.isString(node)) {
            this.rawNode = node;
            return SimpleType.STRING;
        }
        if (this.isDecimal(node)) {
            this.rawNode = this.asNumber(node).stripTrailingZeros();
            if (SimpleJsonNode.canConvertToInteger((BigDecimal)this.rawNode)) {
                return SimpleType.INTEGER;
            }
            return SimpleType.NUMBER;
        }
        if (this.isInteger(node)) {
            this.rawNode = this.asNumber(node);
            return SimpleType.INTEGER;
        }
        if (this.isArray(node)) {
            return SimpleType.ARRAY;
        }
        if (this.isObject(node)) {
            return SimpleType.OBJECT;
        }
        throw new IllegalArgumentException("Cannot assign type to node of class=" + node.getClass().getName());
    }

    private BigDecimal asNumber(Object node) {
        if (node instanceof BigDecimal) {
            return (BigDecimal)node;
        }
        if (node instanceof BigInteger) {
            this.rawBigInt = (BigInteger)node;
            return new BigDecimal((BigInteger)node);
        }
        if (node instanceof Double) {
            return BigDecimal.valueOf((Double)node);
        }
        return BigDecimal.valueOf(((Number)node).longValue());
    }

    private boolean isBoolean(Object node) {
        return node instanceof Boolean;
    }

    private boolean isString(Object node) {
        return node instanceof Character || node instanceof String || node instanceof Enum;
    }

    private boolean isInteger(Object node) {
        return node instanceof Integer || node instanceof Long || node instanceof BigInteger;
    }

    private boolean isDecimal(Object node) {
        return node instanceof Double || node instanceof BigDecimal;
    }
}

