/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema.providers;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeFactory;
import dev.harrel.jsonschema.providers.MapUtil;
import dev.harrel.jsonschema.providers.SimpleJsonNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;

public final class JsonSmartNode
extends SimpleJsonNode {
    private JsonSmartNode(Object node, String jsonPointer) {
        super(node, jsonPointer);
    }

    public JsonSmartNode(Object node) {
        this(node, "");
    }

    @Override
    List<JsonNode> createArray() {
        JSONArray jsonArray = (JSONArray)this.node;
        ArrayList<JsonNode> result = new ArrayList<JsonNode>(jsonArray.size());
        for (int i = 0; i < jsonArray.size(); ++i) {
            result.add(new JsonSmartNode(jsonArray.get(i), this.jsonPointer + "/" + i));
        }
        return result;
    }

    @Override
    Map<String, JsonNode> createObject() {
        Set objectMap = ((JSONObject)this.node).entrySet();
        HashMap<String, JsonNode> result = MapUtil.newHashMap(objectMap.size());
        for (Map.Entry entry : objectMap) {
            result.put((String)entry.getKey(), new JsonSmartNode(entry.getValue(), this.jsonPointer + "/" + JsonNode.encodeJsonPointer((String)entry.getKey())));
        }
        return result;
    }

    @Override
    boolean isNull(Object node) {
        return node == null;
    }

    @Override
    boolean isArray(Object node) {
        return node instanceof JSONArray;
    }

    @Override
    boolean isObject(Object node) {
        return node instanceof JSONObject;
    }

    public static final class Factory
    implements JsonNodeFactory {
        private final JSONParser parser;

        public Factory() {
            this(new JSONParser(8128));
        }

        public Factory(JSONParser parser) {
            this.parser = parser;
        }

        @Override
        public JsonSmartNode wrap(Object node) {
            if (node instanceof JsonSmartNode) {
                return new JsonSmartNode(((JsonSmartNode)node).node);
            }
            return new JsonSmartNode(node);
        }

        @Override
        public JsonSmartNode create(String rawJson) {
            try {
                return new JsonSmartNode(this.parser.parse(rawJson));
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

