/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema.providers;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeFactory;
import dev.harrel.jsonschema.SimpleType;
import dev.harrel.jsonschema.providers.AbstractJsonNode;
import dev.harrel.jsonschema.providers.MapUtil;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class JakartaJsonNode
extends AbstractJsonNode<JsonValue> {
    private JakartaJsonNode(JsonValue node, String jsonPointer) {
        super(Objects.requireNonNull(node), jsonPointer);
    }

    public JakartaJsonNode(JsonValue node) {
        this(node, "");
    }

    @Override
    List<JsonNode> createArray() {
        JsonArray jsonArray = ((JsonValue)this.node).asJsonArray();
        ArrayList<JsonNode> result = new ArrayList<JsonNode>(jsonArray.size());
        for (int i = 0; i < jsonArray.size(); ++i) {
            result.add(new JakartaJsonNode((JsonValue)jsonArray.get(i), this.jsonPointer + "/" + i));
        }
        return result;
    }

    @Override
    Map<String, JsonNode> createObject() {
        Set objectMap = ((JsonValue)this.node).asJsonObject().entrySet();
        HashMap<String, JsonNode> result = MapUtil.newHashMap(objectMap.size());
        for (Map.Entry entry : objectMap) {
            result.put((String)entry.getKey(), new JakartaJsonNode((JsonValue)entry.getValue(), this.jsonPointer + "/" + JsonNode.encodeJsonPointer((String)entry.getKey())));
        }
        return result;
    }

    @Override
    SimpleType computeNodeType(JsonValue node) {
        switch (node.getValueType()) {
            case NULL: {
                return SimpleType.NULL;
            }
            case ARRAY: {
                return SimpleType.ARRAY;
            }
            case OBJECT: {
                return SimpleType.OBJECT;
            }
            case STRING: {
                this.rawNode = ((JsonString)node).getString();
                return SimpleType.STRING;
            }
            case TRUE: {
                this.rawNode = Boolean.TRUE;
                return SimpleType.BOOLEAN;
            }
            case FALSE: {
                this.rawNode = Boolean.FALSE;
                return SimpleType.BOOLEAN;
            }
            case NUMBER: {
                this.rawNode = ((JsonNumber)node).bigDecimalValue();
                if (JakartaJsonNode.canConvertToInteger((BigDecimal)this.rawNode)) {
                    return SimpleType.INTEGER;
                }
                return SimpleType.NUMBER;
            }
        }
        throw new IllegalArgumentException("Unknown node type=" + node.getValueType());
    }

    public static final class Factory
    implements JsonNodeFactory {
        private final JsonParserFactory parserFactory;

        public Factory() {
            this(Json.createParserFactory(Collections.emptyMap()));
        }

        public Factory(JsonParserFactory parserFactory) {
            this.parserFactory = parserFactory;
        }

        @Override
        public JakartaJsonNode wrap(Object node) {
            if (node instanceof JakartaJsonNode) {
                return new JakartaJsonNode((JsonValue)((JakartaJsonNode)node).node);
            }
            if (node instanceof JsonValue) {
                return new JakartaJsonNode((JsonValue)node);
            }
            throw new IllegalArgumentException("Cannot wrap object which is not an instance of jakarta.json.JsonValue");
        }

        @Override
        public JakartaJsonNode create(String rawJson) {
            try (JsonParser parser = this.parserFactory.createParser((Reader)new StringReader(rawJson));){
                parser.next();
                JakartaJsonNode jakartaJsonNode = new JakartaJsonNode(parser.getValue());
                return jakartaJsonNode;
            }
        }
    }
}

