/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema.providers;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SimpleType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

abstract class AbstractJsonNode<T>
implements JsonNode {
    private final SimpleType nodeType;
    final T node;
    final String jsonPointer;
    Object rawNode;
    BigInteger rawBigInt;

    AbstractJsonNode(T node, String jsonPointer) {
        this.nodeType = this.computeNodeType(node);
        this.node = node;
        this.jsonPointer = Objects.requireNonNull(jsonPointer);
    }

    @Override
    public String getJsonPointer() {
        return this.jsonPointer;
    }

    @Override
    public SimpleType getNodeType() {
        return this.nodeType;
    }

    @Override
    public boolean asBoolean() {
        return (Boolean)this.rawNode;
    }

    @Override
    public String asString() {
        return Objects.toString(this.rawNode);
    }

    @Override
    public BigInteger asInteger() {
        if (this.rawBigInt == null) {
            this.rawBigInt = this.asNumber().toBigInteger();
        }
        return this.rawBigInt;
    }

    @Override
    public BigDecimal asNumber() {
        return (BigDecimal)this.rawNode;
    }

    @Override
    public final List<JsonNode> asArray() {
        if (this.rawNode == null) {
            this.rawNode = Collections.unmodifiableList(this.createArray());
        }
        return (List)this.rawNode;
    }

    @Override
    public final Map<String, JsonNode> asObject() {
        if (this.rawNode == null) {
            this.rawNode = Collections.unmodifiableMap(this.createObject());
        }
        return (Map)this.rawNode;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractJsonNode)) {
            return false;
        }
        AbstractJsonNode other = (AbstractJsonNode)obj;
        if (this.getNodeType() != other.getNodeType()) {
            return false;
        }
        this.ensureInitialized();
        other.ensureInitialized();
        if (this.getNodeType() == SimpleType.INTEGER) {
            return Objects.equals(this.rawBigInt, other.rawBigInt);
        }
        return Objects.equals(this.rawNode, other.rawNode);
    }

    public final int hashCode() {
        this.ensureInitialized();
        if (this.getNodeType() == SimpleType.INTEGER) {
            return Objects.hashCode(this.rawBigInt);
        }
        return Objects.hashCode(this.rawNode);
    }

    private void ensureInitialized() {
        if (this.nodeType == SimpleType.INTEGER) {
            this.asInteger();
        } else if (this.nodeType == SimpleType.ARRAY) {
            this.asArray();
        } else if (this.nodeType == SimpleType.OBJECT) {
            this.asObject();
        }
    }

    abstract List<JsonNode> createArray();

    abstract Map<String, JsonNode> createObject();

    abstract SimpleType computeNodeType(T var1);

    static boolean canConvertToInteger(BigDecimal bigDecimal) {
        return bigDecimal.scale() <= 0 || bigDecimal.stripTrailingZeros().scale() <= 0;
    }
}

