/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompoundUri;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;

final class UriUtil {
    private UriUtil() {
    }

    static URI getUriWithoutFragment(URI uri) {
        if (uri.getRawFragment() == null) {
            return uri;
        }
        return UriUtil.getUriWithoutFragment(uri.toString());
    }

    static URI getUriWithoutFragment(String uri) {
        int fragmentIdx = uri.indexOf(35);
        if (fragmentIdx < 0) {
            return URI.create(uri);
        }
        return URI.create(uri.substring(0, fragmentIdx));
    }

    static URI removeEmptyFragment(String uri) {
        if (uri.endsWith("#")) {
            return URI.create(uri.substring(0, uri.length() - 1));
        }
        return URI.create(uri);
    }

    static String getJsonPointer(String uri) {
        int fragmentIdx = uri.indexOf(35);
        if (fragmentIdx < 0) {
            return "";
        }
        return uri.substring(fragmentIdx + 1);
    }

    static String getJsonPointerParent(String pointer) {
        return pointer.substring(0, pointer.lastIndexOf(47));
    }

    static CompoundUri resolveUri(URI baseUri, CompoundUri ref) {
        String fragment = UriUtil.urlDecode(ref.fragment);
        if (ref.uri.toString().isEmpty()) {
            return new CompoundUri(baseUri, fragment);
        }
        return new CompoundUri(baseUri.resolve(ref.uri), fragment);
    }

    private static String urlDecode(String url) {
        try {
            return URLDecoder.decode(url, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

