/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeUtil;
import dev.harrel.jsonschema.providers.InternalProviderUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

class UniqueItemsEvaluator
implements Evaluator {
    private final boolean unique;

    UniqueItemsEvaluator(JsonNode node) {
        if (!node.isBoolean()) {
            throw new IllegalArgumentException();
        }
        this.unique = node.asBoolean();
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isArray() || !this.unique) {
            return Evaluator.Result.success();
        }
        List<JsonNode> jsonNodes = node.asArray();
        if (InternalProviderUtil.canUseNativeEquals(node)) {
            HashSet<JsonNode> parsed = new HashSet<JsonNode>();
            for (int i = 0; i < jsonNodes.size(); ++i) {
                if (parsed.add(jsonNodes.get(i))) continue;
                return Evaluator.Result.failure(String.format("Array contains non-unique item at index [%d]", i));
            }
        } else {
            ArrayList<JsonNode> parsed = new ArrayList<JsonNode>(jsonNodes.size());
            for (int i = 0; i < jsonNodes.size(); ++i) {
                JsonNode element = jsonNodes.get(i);
                if (parsed.stream().anyMatch(parsedNode -> JsonNodeUtil.equals(parsedNode, element))) {
                    return Evaluator.Result.failure(String.format("Array contains non-unique item at index [%d]", i));
                }
                parsed.add(element);
            }
        }
        return Evaluator.Result.success();
    }
}

