/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.EvaluatorWrapper;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeUtil;
import dev.harrel.jsonschema.MetaSchemaData;
import dev.harrel.jsonschema.UriUtil;
import java.net.URI;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

final class Schema {
    private static final Evaluator TRUE_EVALUATOR = (ctx, node) -> Evaluator.Result.success();
    private static final Evaluator FALSE_EVALUATOR = (ctx, node) -> Evaluator.Result.failure("False schema always fails");
    private final URI parentUri;
    private final String schemaLocation;
    private final String schemaLocationFragment;
    private final List<EvaluatorWrapper> evaluators;
    private final MetaSchemaData metaSchemaData;

    Schema(URI parentUri, String schemaLocation, List<EvaluatorWrapper> evaluators, MetaSchemaData metaSchemaData, Map<String, JsonNode> objectMap) {
        this.parentUri = Objects.requireNonNull(parentUri);
        this.schemaLocation = Objects.requireNonNull(schemaLocation);
        this.schemaLocationFragment = UriUtil.getJsonPointer(schemaLocation);
        this.evaluators = evaluators;
        this.evaluators.sort(Comparator.comparingInt(Evaluator::getOrder));
        Optional<Map<String, Boolean>> vocabulariesObject = JsonNodeUtil.getVocabulariesObject(objectMap);
        Set<String> vocabularies = vocabulariesObject.map(Map::keySet).orElse(metaSchemaData.activeVocabularies);
        this.metaSchemaData = new MetaSchemaData(metaSchemaData.dialect, vocabulariesObject.orElse(null), vocabularies);
    }

    static Evaluator getBooleanEvaluator(boolean val) {
        return val ? TRUE_EVALUATOR : FALSE_EVALUATOR;
    }

    URI getParentUri() {
        return this.parentUri;
    }

    String getSchemaLocation() {
        return this.schemaLocation;
    }

    String getSchemaLocationFragment() {
        return this.schemaLocationFragment;
    }

    List<EvaluatorWrapper> getEvaluators() {
        return this.evaluators;
    }

    MetaSchemaData getMetaValidationData() {
        return this.metaSchemaData;
    }
}

