/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class ItemsLegacyEvaluator
implements Evaluator {
    private final CompoundUri schemaRef;
    private final List<CompoundUri> schemaRefs;

    ItemsLegacyEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (node.isObject() || node.isBoolean()) {
            this.schemaRef = ctx.getCompoundUri(node);
            this.schemaRefs = null;
        } else if (node.isArray()) {
            this.schemaRef = null;
            this.schemaRefs = Collections.unmodifiableList(node.asArray().stream().map(ctx::getCompoundUri).collect(Collectors.toList()));
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isArray()) {
            return Evaluator.Result.success();
        }
        List<JsonNode> array = node.asArray();
        if (this.schemaRef != null) {
            boolean valid = true;
            for (JsonNode element : array) {
                valid = ctx.resolveInternalRefAndValidate(this.schemaRef, element) && valid;
            }
            return valid ? Evaluator.Result.success(true) : Evaluator.Result.annotatedFailure(true);
        }
        int size = Math.min(this.schemaRefs.size(), array.size());
        boolean valid = true;
        for (int i = 0; i < size; ++i) {
            valid = ctx.resolveInternalRefAndValidate(this.schemaRefs.get(i), array.get(i)) && valid;
        }
        Boolean annotation = size == array.size() ? (Comparable<Boolean>)Boolean.TRUE : (Comparable<Boolean>)Integer.valueOf(this.schemaRefs.size());
        return valid ? Evaluator.Result.success(annotation) : Evaluator.Result.annotatedFailure(annotation);
    }
}

