/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.JsonNode;
import java.util.Set;
import java.util.function.Supplier;

public interface Evaluator {
    public Result evaluate(EvaluationContext var1, JsonNode var2);

    default public int getOrder() {
        return 0;
    }

    @Deprecated
    default public Set<String> getVocabularies() {
        throw new UnsupportedOperationException();
    }

    public static final class Result {
        private static final Result SUCCESSFUL_RESULT = new Result(true, null, null);
        private static final Result FAILED_RESULT = new Result(false, null, () -> null);
        private final boolean valid;
        private final Object annotation;
        private final Supplier<String> errorSupplier;

        private Result(boolean valid, Object annotation, Supplier<String> errorSupplier) {
            this.valid = valid;
            this.annotation = annotation;
            this.errorSupplier = errorSupplier;
        }

        public static Result success() {
            return SUCCESSFUL_RESULT;
        }

        public static Result success(Object annotation) {
            return new Result(true, annotation, null);
        }

        public static Result failure() {
            return FAILED_RESULT;
        }

        public static Result failure(String message) {
            return new Result(false, null, () -> message);
        }

        static Result failure(Supplier<String> messageSupplier) {
            return new Result(false, null, messageSupplier);
        }

        static Result annotatedFailure(Object annotation) {
            return new Result(false, annotation, () -> null);
        }

        boolean isValid() {
            return this.valid;
        }

        Object getAnnotation() {
            return this.annotation;
        }

        Supplier<String> getErrorSupplier() {
            return this.errorSupplier;
        }
    }
}

