/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Annotation;
import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.EvaluatorWrapper;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeFactory;
import dev.harrel.jsonschema.JsonParser;
import dev.harrel.jsonschema.Keyword;
import dev.harrel.jsonschema.LazyError;
import dev.harrel.jsonschema.Schema;
import dev.harrel.jsonschema.SchemaNotFoundException;
import dev.harrel.jsonschema.SchemaRegistry;
import dev.harrel.jsonschema.SchemaResolver;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class EvaluationContext {
    private final JsonNodeFactory jsonNodeFactory;
    private final JsonParser jsonParser;
    private final SchemaRegistry schemaRegistry;
    private final SchemaResolver schemaResolver;
    private final Deque<URI> dynamicScope = new ArrayDeque<URI>();
    private final Deque<RefStackItem> refStack = new ArrayDeque<RefStackItem>();
    private final Deque<Integer> annotationsBeforeStack = new ArrayDeque<Integer>();
    private final Deque<Map<String, Annotation>> siblingAnnotationsStack = new ArrayDeque<Map<String, Annotation>>();
    private final Deque<String> evaluationStack = new ArrayDeque<String>();
    private final List<Annotation> annotations = new ArrayList<Annotation>();
    private final List<LazyError> errors = new ArrayList<LazyError>();

    EvaluationContext(JsonNodeFactory jsonNodeFactory, JsonParser jsonParser, SchemaRegistry schemaRegistry, SchemaResolver schemaResolver) {
        this.jsonNodeFactory = Objects.requireNonNull(jsonNodeFactory);
        this.jsonParser = Objects.requireNonNull(jsonParser);
        this.schemaRegistry = Objects.requireNonNull(schemaRegistry);
        this.schemaResolver = Objects.requireNonNull(schemaResolver);
        this.evaluationStack.push("");
    }

    public boolean resolveRefAndValidate(String schemaRef, JsonNode node) {
        return this.resolveRefAndValidate(CompoundUri.fromString(schemaRef), node);
    }

    boolean resolveRefAndValidate(CompoundUri compoundUri, JsonNode node) {
        Schema schema = this.resolveSchema(compoundUri);
        if (schema == null) {
            throw new SchemaNotFoundException(compoundUri);
        }
        return this.validateAgainstRefSchema(schema, node);
    }

    public boolean resolveDynamicRefAndValidate(String schemaRef, JsonNode node) {
        return this.resolveDynamicRefAndValidate(CompoundUri.fromString(schemaRef), node);
    }

    boolean resolveDynamicRefAndValidate(CompoundUri compoundUri, JsonNode node) {
        Schema schema = this.resolveDynamicSchema(compoundUri);
        if (schema == null) {
            throw new SchemaNotFoundException(compoundUri);
        }
        return this.validateAgainstRefSchema(schema, node);
    }

    public boolean resolveRecursiveRefAndValidate(String schemaRef, JsonNode node) {
        Schema schema = this.resolveRecursiveSchema();
        if (schema == null) {
            throw new SchemaNotFoundException(CompoundUri.fromString(schemaRef));
        }
        return this.validateAgainstRefSchema(schema, node);
    }

    public boolean resolveInternalRefAndValidate(String schemaRef, JsonNode node) {
        return this.resolveInternalRefAndValidate(CompoundUri.fromString(schemaRef), node);
    }

    boolean resolveInternalRefAndValidate(CompoundUri compoundUri, JsonNode node) {
        Schema schema = this.schemaRegistry.get(compoundUri);
        if (schema == null) {
            throw new SchemaNotFoundException(compoundUri);
        }
        return this.validateAgainstSchema(schema, node);
    }

    List<Annotation> getAnnotations() {
        return Collections.unmodifiableList(this.annotations);
    }

    List<LazyError> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    Object getSiblingAnnotation(String sibling) {
        Annotation annotation = this.siblingAnnotationsStack.element().get(sibling);
        return annotation == null ? null : annotation.getAnnotation();
    }

    Map.Entry<Integer, Set<Integer>> calculateEvaluatedItems(String instanceLocation) {
        int fromIdx = this.annotationsBeforeStack.element();
        HashSet items = new HashSet();
        int maxIdx = 0;
        for (int i = fromIdx; i < this.annotations.size(); ++i) {
            Annotation annotation = this.annotations.get(i);
            if (!annotation.getInstanceLocation().equals(instanceLocation)) continue;
            if (Keyword.ITEM_KEYWORDS.contains(annotation.getKeyword())) {
                if (annotation.getAnnotation() instanceof Boolean) {
                    return new AbstractMap.SimpleEntry<Integer, Set<Integer>>(Integer.MAX_VALUE, Collections.emptySet());
                }
                maxIdx = Math.max(maxIdx, (Integer)annotation.getAnnotation());
                continue;
            }
            if (!annotation.getKeyword().equals("contains")) continue;
            items.addAll((Collection)annotation.getAnnotation());
        }
        return new AbstractMap.SimpleEntry<Integer, Set<Integer>>(maxIdx, items);
    }

    Set<String> calculateEvaluatedProperties(String instanceLocation) {
        int fromIdx = this.annotationsBeforeStack.element();
        HashSet<String> props = new HashSet<String>();
        for (int i = fromIdx; i < this.annotations.size(); ++i) {
            Annotation annotation = this.annotations.get(i);
            if (!annotation.getInstanceLocation().equals(instanceLocation) || !Keyword.PROPERTY_KEYWORDS.contains(annotation.getKeyword())) continue;
            props.addAll((Collection)annotation.getAnnotation());
        }
        return props;
    }

    boolean validateAgainstSchema(Schema schema, JsonNode node) {
        boolean outOfDynamicScope;
        boolean bl = outOfDynamicScope = !schema.getParentUri().equals(this.dynamicScope.peek());
        if (outOfDynamicScope) {
            this.dynamicScope.push(schema.getParentUri());
        }
        int annotationsBefore = this.annotations.size();
        HashMap<String, Annotation> siblingAnnotations = new HashMap<String, Annotation>();
        this.annotationsBeforeStack.push(annotationsBefore);
        this.siblingAnnotationsStack.push(siblingAnnotations);
        List<EvaluatorWrapper> evaluators = schema.getEvaluators();
        int evaluatorsSize = evaluators.size();
        boolean valid = true;
        for (int i = 0; i < evaluatorsSize; ++i) {
            EvaluatorWrapper evaluator = evaluators.get(i);
            String evaluationPath = this.resolveEvaluationPath(evaluator);
            this.evaluationStack.push(evaluationPath);
            int errorsBefore = this.errors.size();
            Evaluator.Result result = evaluator.evaluate(this, node);
            if (result.getAnnotation() != null) {
                Annotation annotation = new Annotation(evaluationPath, schema.getSchemaLocation(), node.getJsonPointer(), evaluator.getKeyword(), result.getAnnotation());
                siblingAnnotations.put(evaluator.getKeyword(), annotation);
                this.annotations.add(annotation);
            }
            if (result.isValid()) {
                this.errors.subList(errorsBefore, this.errors.size()).clear();
            } else {
                valid = false;
                this.errors.add(new LazyError(evaluationPath, schema.getSchemaLocation(), node.getJsonPointer(), evaluator.getKeyword(), result.getErrorSupplier()));
            }
            this.evaluationStack.pop();
        }
        if (!valid) {
            this.annotations.subList(annotationsBefore, this.annotations.size()).clear();
        }
        this.siblingAnnotationsStack.pop();
        this.annotationsBeforeStack.pop();
        if (outOfDynamicScope) {
            this.dynamicScope.pop();
        }
        return valid;
    }

    private boolean validateAgainstRefSchema(Schema schema, JsonNode node) {
        this.refStack.push(new RefStackItem(schema.getSchemaLocationFragment(), this.evaluationStack.peek()));
        boolean valid = this.validateAgainstSchema(schema, node);
        this.refStack.pop();
        return valid;
    }

    private Schema resolveSchema(CompoundUri compoundUri) {
        Schema schema = this.schemaRegistry.get(compoundUri);
        if (schema != null) {
            return schema;
        }
        schema = this.schemaRegistry.getDynamic(compoundUri);
        if (schema != null) {
            return schema;
        }
        return this.resolveExternalSchema(compoundUri);
    }

    private Schema resolveDynamicSchema(CompoundUri compoundUri) {
        Schema staticSchema = this.schemaRegistry.get(compoundUri);
        if (staticSchema != null) {
            return staticSchema;
        }
        Iterator<URI> it = this.dynamicScope.descendingIterator();
        while (it.hasNext()) {
            Schema schema = this.schemaRegistry.getDynamic(new CompoundUri(it.next(), compoundUri.fragment));
            if (schema == null) continue;
            return schema;
        }
        return null;
    }

    private Schema resolveRecursiveSchema() {
        Schema schema = this.schemaRegistry.get(this.dynamicScope.element());
        for (URI uri : this.dynamicScope) {
            Schema recursedSchema = this.schemaRegistry.getDynamic(uri);
            if (recursedSchema == null) {
                return schema;
            }
            schema = recursedSchema;
        }
        return schema;
    }

    private String resolveEvaluationPath(EvaluatorWrapper evaluator) {
        if (this.refStack.isEmpty()) {
            return evaluator.getKeywordPath();
        }
        RefStackItem refItem = this.refStack.peek();
        String evaluationPathPart = evaluator.getKeywordPath().substring(refItem.schemaLocation.length());
        return refItem.evaluationPath + evaluationPathPart;
    }

    private Schema resolveExternalSchema(CompoundUri compoundUri) {
        if (this.schemaRegistry.get(compoundUri.uri) != null) {
            return null;
        }
        return this.schemaResolver.resolve(compoundUri.uri.toString()).toJsonNode(this.jsonNodeFactory).map(node -> {
            this.jsonParser.parseRootSchema(compoundUri.uri, (JsonNode)node);
            return this.resolveSchema(compoundUri);
        }).orElse(null);
    }

    private static class RefStackItem {
        private final String schemaLocation;
        private final String evaluationPath;

        private RefStackItem(String schemaLocation, String evaluationPath) {
            this.schemaLocation = schemaLocation;
            this.evaluationPath = evaluationPath;
        }
    }
}

