/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

class AdditionalPropertiesEvaluator
implements Evaluator {
    private final CompoundUri schemaRef;
    private final Set<String> propertyNames;
    private final boolean hasPatternProperties;

    AdditionalPropertiesEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject() && !node.isBoolean()) {
            throw new IllegalArgumentException();
        }
        this.schemaRef = ctx.getCompoundUri(node);
        Set<Object> tmpProps = Collections.emptySet();
        JsonNode propertiesNode = ctx.getCurrentSchemaObject().get("properties");
        if (propertiesNode != null && propertiesNode.isObject()) {
            tmpProps = propertiesNode.asObject().keySet();
        }
        this.propertyNames = Collections.unmodifiableSet(tmpProps);
        this.hasPatternProperties = ctx.getCurrentSchemaObject().containsKey("patternProperties");
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        Object patternAnnotation;
        if (!node.isObject()) {
            return Evaluator.Result.success();
        }
        Set patternNames = Collections.emptySet();
        if (this.hasPatternProperties && (patternAnnotation = ctx.getSiblingAnnotation("patternProperties")) instanceof Set) {
            patternNames = (Set)patternAnnotation;
        }
        Map<String, JsonNode> objectMap = node.asObject();
        ArrayList<String> processed = new ArrayList<String>(objectMap.size());
        boolean valid = true;
        for (Map.Entry<String, JsonNode> entry : objectMap.entrySet()) {
            String key = entry.getKey();
            if (this.propertyNames.contains(key) || patternNames.contains(key)) continue;
            processed.add(key);
            valid = ctx.resolveInternalRefAndValidate(this.schemaRef, entry.getValue()) && valid;
        }
        return valid ? Evaluator.Result.success(Collections.unmodifiableList(processed)) : Evaluator.Result.annotatedFailure(Collections.unmodifiableList(processed));
    }

    @Override
    public int getOrder() {
        return 10;
    }
}

