/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaNotFoundException;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.UriUtil;

class RefEvaluator
implements Evaluator {
    private final CompoundUri ref;

    RefEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isString()) {
            throw new IllegalArgumentException();
        }
        this.ref = UriUtil.resolveUri(ctx.getParentUri(), CompoundUri.fromString(node.asString()));
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        try {
            return ctx.resolveRefAndValidate(this.ref, node) ? Evaluator.Result.success() : Evaluator.Result.failure();
        }
        catch (SchemaNotFoundException e) {
            return Evaluator.Result.failure(String.format("Resolution of $ref [%s] failed", this.ref));
        }
    }
}

