/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.ValidatingEvaluator;
import java.math.BigDecimal;

class MultipleOfEvaluator
implements ValidatingEvaluator {
    private final BigDecimal factor;

    MultipleOfEvaluator(JsonNode node) {
        if (!node.isNumber()) {
            throw new IllegalArgumentException();
        }
        this.factor = node.asNumber();
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isNumber()) {
            return Evaluator.Result.success();
        }
        if (node.asNumber().remainder(this.factor).doubleValue() == 0.0) {
            return Evaluator.Result.success();
        }
        return Evaluator.Result.failure(String.format("%s is not multiple of %s", node.asNumber(), this.factor));
    }
}

