/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Dialect;
import dev.harrel.jsonschema.Draft2019EvaluatorFactory;
import dev.harrel.jsonschema.Draft2020EvaluatorFactory;
import dev.harrel.jsonschema.EvaluatorFactory;
import dev.harrel.jsonschema.SpecificationVersion;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class Dialects {
    private Dialects() {
    }

    public static class Draft2019Dialect
    implements Dialect {
        private final EvaluatorFactory evaluatorFactory = new Draft2019EvaluatorFactory();
        private final Set<String> requiredVocabularies = Collections.singleton("https://json-schema.org/draft/2019-09/vocab/core");
        private final Map<String, Boolean> defaultVocabularyObject;

        public Draft2019Dialect() {
            HashMap<String, Boolean> vocabs = new HashMap<String, Boolean>();
            vocabs.put("https://json-schema.org/draft/2019-09/vocab/core", true);
            vocabs.put("https://json-schema.org/draft/2019-09/vocab/applicator", true);
            vocabs.put("https://json-schema.org/draft/2019-09/vocab/validation", true);
            vocabs.put("https://json-schema.org/draft/2019-09/vocab/meta-data", true);
            vocabs.put("https://json-schema.org/draft/2019-09/vocab/format", false);
            vocabs.put("https://json-schema.org/draft/2019-09/vocab/content", true);
            this.defaultVocabularyObject = Collections.unmodifiableMap(vocabs);
        }

        @Override
        public SpecificationVersion getSpecificationVersion() {
            return SpecificationVersion.DRAFT2019_09;
        }

        @Override
        public String getMetaSchema() {
            return SpecificationVersion.DRAFT2019_09.getId();
        }

        @Override
        public EvaluatorFactory getEvaluatorFactory() {
            return this.evaluatorFactory;
        }

        @Override
        public Set<String> getSupportedVocabularies() {
            return this.defaultVocabularyObject.keySet();
        }

        @Override
        public Set<String> getRequiredVocabularies() {
            return this.requiredVocabularies;
        }

        @Override
        public Map<String, Boolean> getDefaultVocabularyObject() {
            return this.defaultVocabularyObject;
        }
    }

    public static class Draft2020Dialect
    implements Dialect {
        private final EvaluatorFactory evaluatorFactory = new Draft2020EvaluatorFactory();
        private final Set<String> requiredVocabularies = Collections.singleton("https://json-schema.org/draft/2020-12/vocab/core");
        private final Map<String, Boolean> defaultVocabularyObject;

        public Draft2020Dialect() {
            HashMap<String, Boolean> vocabs = new HashMap<String, Boolean>();
            vocabs.put("https://json-schema.org/draft/2020-12/vocab/core", true);
            vocabs.put("https://json-schema.org/draft/2020-12/vocab/applicator", true);
            vocabs.put("https://json-schema.org/draft/2020-12/vocab/unevaluated", true);
            vocabs.put("https://json-schema.org/draft/2020-12/vocab/validation", true);
            vocabs.put("https://json-schema.org/draft/2020-12/vocab/meta-data", true);
            vocabs.put("https://json-schema.org/draft/2020-12/vocab/format-annotation", true);
            vocabs.put("https://json-schema.org/draft/2020-12/vocab/content", true);
            this.defaultVocabularyObject = Collections.unmodifiableMap(vocabs);
        }

        @Override
        public SpecificationVersion getSpecificationVersion() {
            return SpecificationVersion.DRAFT2020_12;
        }

        @Override
        public String getMetaSchema() {
            return SpecificationVersion.DRAFT2020_12.getId();
        }

        @Override
        public EvaluatorFactory getEvaluatorFactory() {
            return this.evaluatorFactory;
        }

        @Override
        public Set<String> getSupportedVocabularies() {
            return this.defaultVocabularyObject.keySet();
        }

        @Override
        public Set<String> getRequiredVocabularies() {
            return this.requiredVocabularies;
        }

        @Override
        public Map<String, Boolean> getDefaultVocabularyObject() {
            return this.defaultVocabularyObject;
        }
    }
}

