/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.Vocabulary;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class AdditionalPropertiesEvaluator
implements Evaluator {
    private final CompoundUri schemaRef;

    AdditionalPropertiesEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject() && !node.isBoolean()) {
            throw new IllegalArgumentException();
        }
        this.schemaRef = ctx.getCompoundUri(node);
    }

    @Override
    public Set<String> getVocabularies() {
        return Vocabulary.APPLICATOR_VOCABULARY;
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isObject()) {
            return Evaluator.Result.success();
        }
        String instanceLocation = node.getJsonPointer();
        HashSet props = new HashSet();
        props.addAll(ctx.getSiblingAnnotation("properties", instanceLocation, Set.class).orElse(Collections.emptySet()));
        props.addAll(ctx.getSiblingAnnotation("patternProperties", instanceLocation, Set.class).orElse(Collections.emptySet()));
        HashSet<String> processed = new HashSet<String>();
        boolean valid = true;
        for (Map.Entry<String, JsonNode> e : node.asObject().entrySet()) {
            if (props.contains(e.getKey())) continue;
            processed.add(e.getKey());
            valid = ctx.resolveInternalRefAndValidate(this.schemaRef, e.getValue()) && valid;
        }
        return valid ? Evaluator.Result.success(Collections.unmodifiableSet(processed)) : Evaluator.Result.failure();
    }

    @Override
    public int getOrder() {
        return 10;
    }
}

