/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.Convert;
import java.io.Serializable;
import java.util.StringTokenizer;

public class Version
implements Cloneable,
Serializable {
    private int major;
    private int minor;
    private int build;

    public Version(int major, int minor, int build) {
        this.major = major;
        this.minor = minor;
        this.build = build;
    }

    public Version(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public Version(String ver) {
        if (ver == null || ver.length() == 0) {
            throw new IllegalArgumentException("Invalid version");
        }
        StringTokenizer tok = new StringTokenizer(ver, ".", false);
        if (tok.hasMoreTokens()) {
            this.major = Convert.tryParseInt(tok.nextToken(), 0);
        }
        if (tok.hasMoreTokens()) {
            this.minor = Convert.tryParseInt(tok.nextToken(), 0);
        }
        if (tok.hasMoreTokens()) {
            this.build = Convert.tryParseInt(tok.nextToken(), 0);
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getBuild() {
        return this.build;
    }

    public int getMinor() {
        return this.minor;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Version)) {
            return false;
        }
        Version rhs = (Version)obj;
        return this.major == rhs.major && this.minor == rhs.minor && this.build == rhs.build;
    }

    public Version clone() {
        return new Version(this.major, this.minor, this.build);
    }

    public int hashCode() {
        return (this.major * 100 + this.minor) * 100000 + this.build;
    }

    public String toString() {
        return String.format("%d.%d.%d", this.major, this.minor, this.build);
    }
}

