/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.ICornerTable;
import dev.fileformat.drako.ICornerTableTraverser;
import dev.fileformat.drako.MeshAttributeIndicesEncodingObserver;

abstract class TraverserBase<TCornerTable extends ICornerTable>
implements ICornerTableTraverser<TCornerTable> {
    protected TCornerTable corner_table_;
    protected boolean[] is_face_visited_;
    protected boolean[] is_vertex_visited_;
    protected MeshAttributeIndicesEncodingObserver<TCornerTable> traversal_observer_;

    TraverserBase() {
    }

    public void init(TCornerTable corner_table, MeshAttributeIndicesEncodingObserver<TCornerTable> traversal_observer) {
        this.corner_table_ = corner_table;
        this.is_face_visited_ = new boolean[((ICornerTable)this.corner_table_).getNumFaces()];
        this.is_vertex_visited_ = new boolean[((ICornerTable)this.corner_table_).getNumVertices()];
        this.traversal_observer_ = traversal_observer;
    }

    @Override
    public TCornerTable getCornerTable() {
        return this.corner_table_;
    }

    protected boolean isFaceVisited(int face_id) {
        if (face_id == -1) {
            return true;
        }
        return this.is_face_visited_[face_id];
    }

    protected boolean isCornerVisited(int corner_id) {
        if (corner_id == -1) {
            return true;
        }
        return this.is_face_visited_[corner_id / 3];
    }

    protected void markFaceVisited(int face_id) {
        this.is_face_visited_[face_id] = true;
    }

    protected boolean isVertexVisited(int vert_id) {
        return this.is_vertex_visited_[vert_id];
    }

    protected void markVertexVisited(int vert_id) {
        this.is_vertex_visited_[vert_id] = true;
    }

    @Override
    public abstract void traverseFromCorner(int var1) throws DrakoException;

    @Override
    public abstract void onTraversalStart();

    @Override
    public abstract void onTraversalEnd();
}

