/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

class StringFormatter {
    private static final char[] UHEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] LHEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private char[] format;

    public StringFormatter(String format) {
        this.format = format.toCharArray();
    }

    public String format(Object ... args) {
        StringBuilder result = new StringBuilder(this.format.length * 2);
        block4: for (int i = 0; i < this.format.length; ++i) {
            char ch = this.format[i];
            if (ch != '{') {
                result.append(ch);
                continue;
            }
            if (this.format[++i] == '{') {
                result.append('{');
                continue;
            }
            int idx = 0;
            while (Character.isDigit(this.format[i])) {
                idx = idx * 10 + (this.format[i] - 48);
                ++i;
            }
            switch (this.format[i]) {
                case '}': {
                    result.append(args[idx]);
                    continue block4;
                }
                case ':': {
                    this.appendFormat(result, args[idx], ++i);
                    while (this.format[i] != '}') {
                        ++i;
                    }
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported format string");
                }
            }
        }
        return result.toString();
    }

    private void appendFormat(StringBuilder ret, Object obj, int i) {
        char fmt = this.format[i++];
        switch (fmt) {
            case 'X': 
            case 'x': {
                int pad = 0;
                if (this.format[i] != '}') {
                    pad = this.format[i] - 48;
                }
                this.appendHex(ret, ((Number)obj).intValue(), pad, fmt == 'X');
                break;
            }
            case '#': 
            case '0': {
                int fracts = 0;
                while (this.format[i] != '}' && this.format[i] != '.') {
                    ++i;
                }
                if (this.format[i] == '.') {
                    do {
                        char ch;
                        if ((ch = this.format[++i]) != '0' && ch != '#') continue;
                        ++fracts;
                    } while (this.format[i] != '}');
                }
                if (fracts == 0) {
                    ret.append(Long.toString(((Number)obj).longValue()));
                    break;
                }
                String s = Double.toString(((Number)obj).doubleValue());
                ret.append(s);
                int actualFracts = 0;
                int p = s.indexOf(46);
                if (p == -1) {
                    ret.append('.');
                } else {
                    actualFracts = s.length() - p - 1;
                }
                while (actualFracts < fracts) {
                    ret.append('0');
                    ++actualFracts;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported format string");
            }
        }
    }

    private void appendHex(StringBuilder ret, int val, int pad, boolean upperCase) {
        String hex = Integer.toHexString(val);
        if (upperCase) {
            hex = hex.toUpperCase();
        }
        int zeros = pad - hex.length();
        while (zeros-- > 0) {
            ret.append('0');
        }
        ret.append(hex);
    }
}

