/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.Charsets;
import dev.fileformat.drako.IOUtils;
import dev.fileformat.drako.Internal;
import dev.fileformat.drako.Stream;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;

@Internal
class StreamReader
extends Reader
implements Closeable {
    private CharsetDecoder decoder;
    private Stream stream;
    private boolean eos;
    private int totalRead;
    private int charsRead;
    private ByteBuffer buffer;
    private boolean skipBOM = true;
    private Charset charset;
    private CharBuffer charBuffer = CharBuffer.allocate(512);
    private int fillCount = 0;
    private boolean debug = false;

    public StreamReader(Stream stream) throws IOException {
        this(stream, StandardCharsets.UTF_8, 512);
    }

    public StreamReader(Stream stream, Charset charset, int buffer) throws IOException {
        this.stream = stream;
        this.charset = charset;
        this.buffer = ByteBuffer.allocate(buffer);
        IOUtils.flip(this.charBuffer);
    }

    private CharsetDecoder getDecoder() {
        if (this.decoder == null) {
            Charset cs = this.charset == null ? Charset.defaultCharset() : this.charset;
            this.decoder = cs.newDecoder().onMalformedInput(CodingErrorAction.IGNORE);
        }
        return this.decoder;
    }

    private boolean fill() throws IOException {
        if (this.charBuffer.hasRemaining()) {
            return true;
        }
        if (this.eos) {
            return false;
        }
        CoderResult cr = this.fillImpl();
        if (cr == null) {
            return false;
        }
        if (!this.charBuffer.hasRemaining() && cr.isMalformed() && !this.eos && this.debug) {
            System.out.printf("Failed to decode buffer, cr = %s;%s\n", cr.toString(), this.toString());
        }
        return this.charBuffer.hasRemaining();
    }

    private CoderResult fillImpl() throws IOException {
        byte[] arr = this.buffer.array();
        if (!this.buffer.hasRemaining()) {
            IOUtils.clear(this.buffer);
        }
        int size = this.buffer.remaining();
        int pos = this.buffer.position();
        int bytesRead = this.stream.read(arr, pos, size);
        if (this.debug) {
            System.out.printf("%d = read(arr, %d, %d)\n", bytesRead, pos, size);
        }
        boolean bl = this.eos = bytesRead <= 0 || bytesRead < size;
        if (bytesRead == -1) {
            return null;
        }
        int skip = 0;
        if (this.totalRead == 0 && this.skipBOM) {
            int bom = Charsets.parseByteOrderMark(arr, this.buffer.position(), bytesRead);
            skip = Charsets.getBOMLength(bom);
            if (bom != 0) {
                this.charset = Charsets.charsetFromBOM(bom);
            }
        }
        IOUtils.position(this.buffer, skip);
        IOUtils.limit(this.buffer, bytesRead + pos);
        if (this.debug) {
            System.out.printf("buf = %d,%d\n", this.buffer.position(), this.buffer.limit());
        }
        this.totalRead += bytesRead;
        return this.decode();
    }

    private CoderResult decode() {
        IOUtils.limit(this.charBuffer, this.charBuffer.capacity());
        IOUtils.position(this.charBuffer, 0);
        CharsetDecoder decoder = this.getDecoder();
        CoderResult cr = decoder.decode(this.buffer, this.charBuffer, this.eos);
        if (this.eos) {
            decoder.flush(this.charBuffer);
        }
        this.buffer.compact();
        IOUtils.flip(this.charBuffer);
        return cr;
    }

    public boolean isEndOfStream() {
        if (this.charBuffer.hasRemaining()) {
            return false;
        }
        return this.eos;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("StreamReader[");
        ret.append(String.format("cbuf= %d", this.charBuffer.remaining()));
        ret.append(String.format("buf=%d;", this.buffer.remaining()));
        ret.append(String.format("eof=%d;", this.eos));
        ret.append(String.format("pos=%d/%d;", this.totalRead, this.charsRead));
        ret.append(this.charBuffer);
        ret.append("]");
        return ret.toString();
    }

    public String readLine() throws IOException {
        if (this.isEndOfStream()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        char[] ch = this.charBuffer.array();
        boolean lineFound = false;
        while (!lineFound && this.fill()) {
            int start = this.charBuffer.position();
            int eol = this.charBuffer.limit();
            int len = eol - start;
            int newPos = eol;
            for (int p = start; p < eol; ++p) {
                if (ch[p] != '\n') continue;
                len = p - start;
                newPos = p + 1;
                lineFound = true;
                break;
            }
            sb.append(ch, start, len);
            this.charsRead += len;
            IOUtils.position(this.charBuffer, newPos);
        }
        this.fill();
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '\r') {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public String readToEnd() throws IOException {
        if (this.isEndOfStream()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        char[] ch = this.charBuffer.array();
        while (this.fill()) {
            int start = this.charBuffer.position();
            int eol = this.charBuffer.limit();
            int len = eol - start;
            sb.append(ch, start, len);
            this.charsRead += len;
            IOUtils.position(this.charBuffer, eol);
        }
        return sb.toString();
    }

    @Override
    public int read() throws IOException {
        if (!this.fill()) {
            return -1;
        }
        char ret = this.charBuffer.get();
        if (this.debug) {
            System.out.print(ret);
            System.out.printf("    cbuf=[%d,%d], buf=[%d,%d]\n", this.charBuffer.position(), this.charBuffer.limit(), this.buffer.position(), this.buffer.limit());
        }
        ++this.charsRead;
        return ret;
    }

    public boolean equals(Object rhs) {
        if ("debug:on".equals(rhs)) {
            this.debug = true;
        } else if ("debug:off".equals(rhs)) {
            this.debug = false;
        } else {
            return super.equals(rhs);
        }
        return false;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int ch;
        if (len == 0) {
            return 0;
        }
        int end = off + len;
        int ret = 0;
        for (int i = off; i < end && (ch = this.read()) != -1; ++i) {
            cbuf[i] = (char)ch;
            ++ret;
        }
        if (ret == 0) {
            return -1;
        }
        return ret;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

