/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.Internal;

@Internal
class Stopwatch {
    private long previousTime;
    private long startTime;
    private boolean running;

    Stopwatch() {
    }

    public void start() {
        this.running = true;
        long now = System.currentTimeMillis();
        this.previousTime += now - this.startTime;
        this.startTime = now;
    }

    public void restart() {
        this.previousTime = 0L;
        this.startTime = System.currentTimeMillis();
        this.running = true;
    }

    public void stop() {
        this.running = false;
        long now = System.currentTimeMillis();
        this.previousTime += now - this.startTime;
    }

    public long elapsedMilliseconds() {
        long ret = this.previousTime;
        if (this.running) {
            ret += System.currentTimeMillis() - this.startTime;
        }
        return ret;
    }
}

